package ru.yandex.direct.useractionlog.writer;

import java.util.List;
import java.util.function.Consumer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.useractionlog.db.ActionLogWriteRepository;
import ru.yandex.direct.useractionlog.schema.ActionLogRecord;
import ru.yandex.direct.utils.MonotonicTime;
import ru.yandex.direct.utils.NanoTimeClock;

public class ActionWriter implements Consumer<List<ActionLogRecord>> {
    private static final Logger logger = LoggerFactory.getLogger(ActionWriter.class);

    private final ActionLogWriteRepository actionLogWriteRepository;

    public ActionWriter(ActionLogWriteRepository actionLogWriteRepository) {
        this.actionLogWriteRepository = actionLogWriteRepository;
    }

    @Override
    public void accept(List<ActionLogRecord> actions) {
        MonotonicTime start = NanoTimeClock.now();
        actionLogWriteRepository.insert(actions);
        logger.info(
                "Written {} actions in {} sec.",
                actions.size(),
                NanoTimeClock.now().minus(start).toMillis() / 1000.0
        );
    }
}
