package ru.yandex.direct.useractionlog.writer;

import java.time.Duration;

import com.beust.jcommander.Parameter;

import ru.yandex.direct.jcommander.DurationConverter;
import ru.yandex.direct.logging.LoggingInitializerParams;

@SuppressWarnings("checkstyle:visibilitymodifier")
public class CommonParams extends LoggingInitializerParams {
    @Parameter(
            names = {"--skip-log-init"},
            description = "Skip environment based logging initialization."
    )
    public boolean skipLogInit = false;

    @Parameter(
            names = {"--skip-zk-lock"},
            description = "Don't take lock in zookeeper."
    )
    public boolean skipZkLock = false;

    @Parameter(
            names = {"--zk-lock-timeout"},
            description = "Don't try to take lock in zookeeper longer than this timeout.",
            converter = DurationConverter.class
    )
    public Duration zkLockTimeout = Duration.ofMinutes(5);
}
