package ru.yandex.direct.useractionlog.writer;

import com.beust.jcommander.Parameter;

import ru.yandex.direct.jcommander.Command;

@SuppressWarnings("checkstyle:visibilitymodifier")
public class DbCreationCommand extends Command {
    @Parameter(
            names = {"-s", "--script"},
            description = "Instead of creating tables writes to stdout bash-script for creating tables"
    )
    public boolean script = false;

    @Parameter(
            names = {"--merge-tree-label"},
            description = "Label from <macro> section in ClickHouse config."
                    + " See https://clickhouse.yandex/docs/en/single/index.html#creating-replicated-tables"
    )
    public String mergeTreeLabel = "shard";

    @Parameter(
            names = {"--distributed-label"},
            description = "Node name from <remote_servers> section in ClickHouse config."
                    + " Seehttps://clickhouse.yandex/docs/en/single/index.html#distributed"
    )
    public String distributedLabel = "logs";

    public DbCreationCommand() {
        super("db-creation");
    }
}
