package ru.yandex.direct.useractionlog.writer;

import java.text.MessageFormat;
import java.util.function.BiConsumer;

import javax.annotation.ParametersAreNonnullByDefault;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.binlog.reader.EnrichedRow;
import ru.yandex.direct.useractionlog.writer.generator.BatchRowDictProcessing;

@ParametersAreNonnullByDefault
public class ErrorWrapper implements BiConsumer<EnrichedRow, Runnable> {
    private static final Logger logger = LoggerFactory.getLogger(BatchRowDictProcessing.class);
    private final boolean skip;

    public ErrorWrapper(boolean skip) {
        this.skip = skip;
    }

    @Override
    public void accept(EnrichedRow row, Runnable runnable) {
        try {
            runnable.run();
        } catch (RuntimeException err) {
            String message = MessageFormat.format(
                    "Got error while handling row with "
                            + "gtid={0} querySerial={1} rowSerial={2} table={3} eventDateTime={4}",
                    row.getGtid(), row.getQuerySerial(), row.getRowSerial(), row.getTableName(), row.getDateTime());
            if (skip) {
                if (logger.isErrorEnabled()) {
                    logger.error(message, err);
                }
            } else {
                throw new IllegalStateException(message, err);
            }
        }
    }
}
