package ru.yandex.direct.useractionlog.writer;

import java.time.Duration;
import java.util.List;

import com.beust.jcommander.Parameter;

import ru.yandex.direct.jcommander.Command;
import ru.yandex.direct.jcommander.DurationConverter;

@SuppressWarnings("checkstyle:visibilitymodifier")
public class RunCommand extends Command {
    @Parameter(
            names = {"-s", "--mysql-server-id"},
            description = "Server ID than will be used to connect to MySQL as slave. Random if omitted."
    )
    public Integer mysqlServerId = null;

    @Parameter(
            names = {"-p", "--user-log-parallelism"},
            description = "Number of thread that will be used to write logs to clickhouse."
    )
    public int logParallelism = 4;

    @Parameter(
            names = {"-b", "--event-batch-size"},
            description = "Event processing batch size (number of events)."
    )
    public int logBatchSize = 5_000;

    @Parameter(
            names = {"--record-batch-size"},
            description = "Event processing batch size (number of rows)."
    )
    public int recordBatchSize = ActionProcessor.DEFAULT_RECORD_BATCH_SIZE;

    @Parameter(
            names = {"--shard"},
            description = "Shard numbers to process (default - all shards)."
    )
    public List<String> shards;

    @Parameter(
            names = {"--event-batch-duration"},
            description = "Target duration of events batch.",
            converter = DurationConverter.class
    )
    public Duration logBatchDuration = Duration.ofSeconds(10);

    @Parameter(
            names = {"--binlog-keep-alive-timeout"},
            description = "Reconnect to binlog if can't see any event for this amount of time.",
            converter = DurationConverter.class
    )
    public Duration binlogKeepAliveTimeout = Duration.ofSeconds(120);

    @Parameter(
            names = {"--skip-erroneous-events"},
            description = "No fails on incorrect events - just write to log"
    )
    public boolean skipErroneousEvents = false;

    @Parameter(
            names = {"--use-tmpfs"},
            description = "Use tmpfs for temporaty mysql servers"
    )
    public boolean useTmpfs = false;

    public RunCommand() {
        super("run");
    }
}
