package ru.yandex.direct.useractionlog.writer.initdictionaries;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;

import ru.yandex.direct.jcommander.Command;
import ru.yandex.direct.useractionlog.schema.UserActionLogStateType;

@SuppressWarnings("checkstyle:visibilitymodifier")
public class ExtendGtidSetCommand extends Command {
    @Parameter(
            names = {"--shard"},
            description = "Shard name as specified by db-config."
    )
    public String shard;

    @Parameter(
            names = {"--add-gtid"},
            description = "Add new MySQL server GTID to the state. Format: <uuid>:<latest_event_id>"
                    + " WARNING: All transactions before those GTID from those UUID including latest_event_id"
                    + " will not be handled. <latest_event_id> must be positive integer so at least one transaction"
                    + " will not be handled in any case."
    )
    public String addGtid;

    @Parameter(
            names = {"--type"},
            converter = StateTypeConverter.class,
            required = true
    )
    public UserActionLogStateType stateType;

    public ExtendGtidSetCommand() {
        super("extend-gtidset");
    }

    static class StateTypeConverter implements IStringConverter<UserActionLogStateType> {
        @Override
        public UserActionLogStateType convert(String value) {
            return UserActionLogStateType.valueOf(value);
        }
    }
}
