package ru.yandex.direct.useractionlog.writer.initdictionaries;

import java.time.Duration;

import com.beust.jcommander.Parameter;

import ru.yandex.direct.jcommander.Command;
import ru.yandex.direct.jcommander.DurationConverter;

@SuppressWarnings("checkstyle:visibilitymodifier")
public class InitDictionariesCommand extends Command {
    @Parameter(
            names = {"-s", "--mysql-server-id"},
            description = "Server ID than will be used to connect to MySQL as slave."
    )
    public Integer mysqlServerId = null;

    @Parameter(
            names = {"--clickhouse-parallel-writes"},
            description = "ClickHouse parallel writes"
    )
    public int clickhouseParallelWrites = 4;

    @Parameter(
            names = {"--clickhouse-chunk-size"},
            description = "How many new records prefer to fetch from MySQL and insert into ClickHouse tables."
    )
    public int clickhouseChunkSize = 50_000;

    @Parameter(
            names = {"--binlog-reader-timeout"},
            description = "Timeout for binlog reader.",
            converter = DurationConverter.class
    )
    public Duration binlogReaderTimeout = Duration.ofSeconds(180);

    @Parameter(
            names = {"--binlog-keep-alive-timeout"},
            description = "Reconnect to binlog if can't see any event for this amount of time.",
            converter = DurationConverter.class
    )
    public Duration binlogKeepAliveTimeout = Duration.ofSeconds(120);

    public InitDictionariesCommand() {
        super("init-dictionaries");
    }
}
