package ru.yandex.direct.useractionlog.writer.initdictionaries;

import java.util.HashMap;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Информация о том, какая часть работы по инициализации словаря уже завершена.
 */
@NotThreadSafe
@ParametersAreNonnullByDefault
class InitDictionariesState {
    /**
     * Отдельная информация для каждого шарда. Ключ - метка шарда, как её выдаёт
     * {@link ru.yandex.direct.dbutil.wrapper.DatabaseWrapper#getDbname()}
     */
    @JsonProperty
    Map<String, PpcShardState> shardStates = new HashMap<>();

    static class PpcShardState {
        /**
         * Информация о скачивании таблиц SELECT-запросами. Ключ - название таблицы.
         */
        @JsonProperty
        Map<String, SelectState> selects = new HashMap<>();
        /**
         * Последний eventId, использованый при снятии слепка mysql базы
         */
        @JsonProperty
        long lastEventId = 0;

        static class SelectState {
            /**
             * Была ли таблица полностью прочитана
             */
            @JsonProperty
            boolean finished = false;
            /**
             * Последний прочитанный и перенесённый в словарь primary key из таблицы
             */
            @JsonProperty
            Long lastReadPk = null;
        }
    }
}
