package ru.yandex.direct.apps.yt.benchmark;

import java.util.ArrayList;
import java.util.List;

import com.beust.jcommander.Parameter;

public class BenchmarkParams {
    @Parameter(
            names = {"--cluster"},
            description = "Code name of yt cluster",
            required = true
    )
    YtCluster cluster;

    @Parameter(
            names = {"--client"},
            description = "Code name of client"
    )
    List<YtClient> clients = new ArrayList<>();

    @Parameter(
            names = {"--queries-conf"},
            description = "Queries config resource name, default: count-rows.conf"
    )
    String queriesConf = "count-rows.conf";

    @Parameter(
            names = {"--warmup"},
            description = "Warmup iterations num, default: 2"
    )
    int warmup = 2;

    @Parameter(
            names = {"--iterations"},
            description = "Measure iterations num, default: 20"
    )
    int iterations = 20;

    @Parameter(
            names = {"--send-to-solomon"},
            description = "Send metrics to Solomon, default: false"
    )
    boolean sendToSolomon;

    @Parameter(
            names = {"--solomon-flow"},
            description = "Value for label 'flow'"
    )
    String solomonFlow = "yt-benchmark";
}
