package ru.yandex.direct.apps.yt.benchmark;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.config.DirectConfigFactory;
import ru.yandex.direct.jcommander.ParserWithHelp;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    private Main() {
    }

    public static void main(String[] args) {
        BenchmarkParams params = new BenchmarkParams();
        ParserWithHelp.parse(
                Main.class.getCanonicalName(),
                args,
                params
        );

        DirectConfig directConfig = DirectConfigFactory.getConfig();

        try (Benchmark benchmark = new Benchmark(directConfig, params)) {
            benchmark.doIt();
        }
    }
}
