package ru.yandex.direct.apps.yt.benchmark;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import one.util.streamex.StreamEx;

import static java.util.stream.Collectors.toList;

public class QueriesRepository {
    private Map<String, String> vars;
    private List<Query> rawQueries;

    public QueriesRepository(BenchmarkParams params) {
        Config queriesConf = ConfigFactory
                .parseResourcesAnySyntax(params.queriesConf,
                        ConfigParseOptions.defaults().setAllowMissing(false));
        vars = readMap(queriesConf.getConfig("vars"));
        rawQueries = queriesConf.getConfigList("queries").stream()
                .map(q -> Query.of(q.getString("name"), q.getString("query")))
                .collect(toList());

    }

    public List<Query> getQueries() {
        List<Query> ret = new ArrayList<>();
        for (Query rawQuery : rawQueries) {
            String query = rawQuery.query();
            for (String var : vars.keySet()) {
                query = query.replaceAll("\\$\\{" + var + "\\}", vars.get(var));
            }
            ret.add(Query.of(rawQuery.name(), query));
        }
        return ret;
    }

    private Map<String, String> readMap(Config varsConf) {
        return StreamEx.of(varsConf.entrySet()).map(Map.Entry::getKey).toMap(varsConf::getString);
    }
}
