package ru.yandex.direct.apps.yt.benchmark;

import java.util.Objects;

public class Query {
    private final String name;
    private final String query;

    private Query(String name, String query) {
        this.name = name;
        this.query = query;
    }

    public static Query of(String name, String query) {
        return new Query(name, query);
    }

    public String name() {
        return name;
    }

    public String query() {
        return query;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Query query1 = (Query) o;
        return Objects.equals(name, query1.name) &&
                Objects.equals(query, query1.query);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, query);
    }
}
