package ru.yandex.direct.apps.yt.benchmark;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;

import one.util.streamex.EntryStream;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

import ru.yandex.monlib.metrics.registry.MetricRegistry;

public class Stats {
    private final DescriptiveStatistics stats = new DescriptiveStatistics();
    private int requests;
    private int errors;
    private Map<String, AtomicInteger> errorsStat = new HashMap<>();

    public void addSuccessTime(double time) {
        stats.addValue(time);
        requests++;
    }

    public void addError(Exception ex) {
        errorsStat.computeIfAbsent(ex.getMessage(), m -> new AtomicInteger(0))
                .incrementAndGet();
        errors++;
        requests++;
    }

    public String format() {
        StringBuilder sb = new StringBuilder();
        sb.append("Requests: ").append(requests)
                .append(", successes: ").append(requests - errors);
        if (errors > 0) {
            String errorDetails = EntryStream.of(errorsStat)
                    .sortedBy(e -> -e.getValue().get())
                    .map(e -> e.getValue().get() + " - " + e.getKey())
                    .joining(", ");
            sb.append(", errors: ").append(errors)
                    .append(" (").append(errorDetails).append(")");
        }
        sb.append('\n');
        if (stats.getN() > 0) {
            sb.append("Success avg: ").append((int) stats.getMean())
                    .append(" +/- ").append((int) stats.getStandardDeviation())
                    .append(", min: ").append((int) stats.getMin())
                    .append(", 50%: ").append((int) stats.getPercentile(50))
                    .append(", 80%: ").append((int) stats.getPercentile(80))
                    .append(", 90%: ").append((int) stats.getPercentile(90))
                    .append(", max: ").append((int) stats.getMax())
                    .append('\n');
        }
        return sb.toString();
    }

    public void writeMetrics(MetricRegistry registry) {
        BiConsumer<String, Double> addDouble = (s, v) -> {
            registry.gaugeDouble(s).set(v);
        };
        BiConsumer<String, Integer> addLong = (s, v) -> {
            registry.gaugeInt64(s).set(v);
        };
        addLong.accept("requests_count", requests);
        addLong.accept("errors_count", errors);
        if (stats.getN() > 0) {
            addDouble.accept("time_avg", stats.getMean());
            addDouble.accept("time_dev", stats.getStandardDeviation());
            addDouble.accept("time_min", stats.getMin());
            addDouble.accept("time_proc_50", stats.getPercentile(50));
            addDouble.accept("time_proc_80", stats.getPercentile(80));
            addDouble.accept("time_proc_90", stats.getPercentile(90));
            addDouble.accept("time_max", stats.getMax());
        }
    }
}
