package ru.yandex.direct.apps.yt.benchmark;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.impl.YtUtils;
import ru.yandex.inside.yt.kosher.tables.YTableEntryTypes;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;

public class YtClientKosherImpl implements YtClientApi {
    private final Yt yt;

    public YtClientKosherImpl(YtConfig cfg) {
        this.yt = YtUtils.http(cfg.httpProxy(), cfg.token());
    }

    @Override
    public String name() {
        return "kosher";
    }

    @Override
    public int selectRows(String query) {
        AtomicInteger cnt = new AtomicInteger();
        yt.tables().selectRows(
                query,
                Optional.empty(),
                Optional.of(ROWS_LIMIT),
                Optional.of(ROWS_LIMIT),
                true,
                YTableEntryTypes.YSON,
                (Consumer<YTreeMapNode>) x -> cnt.incrementAndGet()
        );
        return cnt.get();
    }

    @Override
    public void close() {
        // pass
    }
}
