package ru.yandex.direct.apps.yt.benchmark;

import java.time.Duration;

import ru.yandex.yt.ytclient.bus.BusConnector;
import ru.yandex.yt.ytclient.bus.DefaultBusConnector;
import ru.yandex.yt.ytclient.misc.YtTimestamp;
import ru.yandex.yt.ytclient.proxy.SelectRowsRequest;
import ru.yandex.yt.ytclient.proxy.YtClient;
import ru.yandex.yt.ytclient.rpc.RpcCredentials;
import ru.yandex.yt.ytclient.rpc.RpcOptions;

public class YtClientRpcImpl implements YtClientApi {
    private final boolean async;

    private final BusConnector busConnector;
    private final YtClient ytClient;

    public YtClientRpcImpl(YtConfig cfg, boolean async) {
        this.async = async;

        // TODO: UNSAFE
        busConnector = new DefaultBusConnector();

        ytClient = new YtClient(busConnector,
                new ru.yandex.yt.ytclient.proxy.YtCluster(cfg.clusterName()),
                new RpcCredentials(cfg.user(), cfg.token()),
                new RpcOptions().setGlobalTimeout(Duration.ofSeconds(30)));
        ytClient.waitProxies().join(); // IGNORE-BAD-JOIN DIRECT-0 - для бенчмарка некритично
    }

    @Override
    public String name() {
        return "rpc" + (async ? "-async" : "");
    }

    @Override
    public int selectRows(String query) {
        SelectRowsRequest request = SelectRowsRequest.of(query)
                .setInputRowsLimit(1_000_000_000)
                .setOutputRowsLimit(1_000_000_000);
        if (async) {
            request.setTimestamp(YtTimestamp.ASYNC_LAST_COMMITTED);
        }
        return ytClient.selectRows(request)
                .join().getRows().size(); // IGNORE-BAD-JOIN DIRECT-0 - для бенчмарка некритично
    }

    @Override
    public void close() {
        ytClient.close();
        busConnector.close();
    }
}
