package ru.yandex.autotests.direct.api.adgroups.add;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.direct.dbschema.ppc.tables.Phrases;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Author buhter
 * Date 01.12.2015
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
public class AddAdGroupStatusesTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    static Long campaignId;

    private static Phrases phrases;

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        ClientInfo client = api.createClient();
        api.as(client);

        campaignId = api.userSteps().campaignSteps().addDefaultTextCampaign(client);
        api.userSteps().clientFakeSteps().fakeClearClientSpentUnits(client.getLogin());
        Long pid = api.userSteps().adGroupsSteps().addGroup(new AdGroupAddItemMap().defaultAdGroupAddItem(campaignId));
//        phrases = api.userSteps().getDBSteps().getPhrasesSteps().getPhrases(pid);
    }

    @Test
    public void testStatusBsSynced() {
//        assertThat("у созданной группы правильный статус синхронизации с БК",
//                phrases.getStatusBsSynced(), equalTo(Status.NO));
    }

    @Test
    public void testStatusModerate() {
//        assertThat("у созданной группы правильный статус модерации",
//                phrases.getStatusModerate(), equalTo(Status.NEW));
    }

    @Test
    public void testStatusPostModerate() {
//        assertThat("у созданной группы правильный статус пост-модерации",
//                phrases.getStatusPostModerate(), equalTo(Status.NO));
    }
}
