package ru.yandex.autotests.direct.api.adgroups.add;


import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.misc.lang.StringUtils.capitalize;

/**
 * Author pavryabov
 * Date 15.08.14
 * https://st.yandex-team.ru/TESTIRT-2022
 */
@Aqua.Test
@Features(AdGroupsFeatures.ADD)
@RunWith(Parameterized.class)
public class AddNameTest {

    @ClassRule
    public static final ApiSteps api = new ApiSteps();

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static AdGroupAddItemMap adGroupAddItemMap;
    private static ClientInfo client;

    @Parameterized.Parameter
    public String description;

    @Parameterized.Parameter(1)
    public String name;

    @Parameterized.Parameter(2)
    public Object expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() throws UnsupportedEncodingException {
        Object[][] data = new Object[][]{
                {"Корректное имя", AdGroupAddItemMap.DEFAULT_NAME, ExpectedResult.success()},
                {"Русское имя с пробелом", "Русское имя с пробелом", ExpectedResult.success()},
                {" English name with space", " English name with space", ExpectedResult.success()},
                {"Некорректная кодировка", new String("Имя".getBytes(StandardCharsets.UTF_8), "Cp1251"),
                        ExpectedResult.success()},
                {"Цифры", "123", ExpectedResult.success()},
                {"Строка из пробелов", " ", ExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetails.GROUP_NAME_CANNOT_BE_EMPTY_STRING))},
                {"Перенос строки", "name\n", ExpectedResult.success()},
                {"Перенос строки с эскейпом", "name\\n", ExpectedResult.success()},
                {"Кавычки", "name\"", ExpectedResult.success()},
                {"XML/HTML тег", "</Name>", ExpectedResult.success()},
                {"Пустая строка", "", ExpectedResult.errors(new Notification(5004, Api5ErrorDetails.GROUP_NAME_CANNOT_BE_EMPTY_STRING))},
                {"Строка максимальной длины", RandomStringUtils.randomAlphabetic(AdGroupAddItemMap.MAX_NAME_LENGTH),
                        ExpectedResult.success()},
                {"Слишком длинная строка", RandomStringUtils.randomAlphabetic(AdGroupAddItemMap.MAX_NAME_LENGTH + 1),
                        ExpectedResult.errors(new Notification(5001,
                                Api5ErrorDetailsJava.FIELD_MAXIMUM_LENGTH_EXCEEDED,
                                capitalize(AdGroupAddItemMap.NAME),
                                AdGroupAddItemMap.MAX_NAME_LENGTH))}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createCampaign() {
        client = api.createClient();
        Long campaignId = api.as(client).userSteps().campaignSteps().addDefaultTextCampaign(client);
        adGroupAddItemMap = new AdGroupAddItemMap()
                .withCampaignId(campaignId)
                .withRegionIds(0L);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps().clientFakeSteps().fakeClearClientSpentUnits(client.getLogin());
    }

    @Test
    public void addGroupWithName() {
        //DIRECT-34280
        api.userSteps().adGroupsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAdGroups(adGroupAddItemMap.withName(name)),
                (ExpectedResult) expectedResult);
    }
}
