package ru.yandex.autotests.direct.api.adgroups.delete;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.directapi.model.api5.adgroups.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.qatools.allure.annotations.Features;

@Features(AdGroupsFeatures.DELETE)
public class DeleteTest {
    private static ClientInfo client;

    @ClassRule
    public static final ApiSteps api = new ApiSteps();

    private static Long performanceAdGroupId;

    @BeforeClass
    public static void initTest() {
        client = api.createClient();
        api.as(client);

        Long performanceCampaignId = api.userSteps().campaignSteps().addDefaultSmartCampaign(client);
        Long feedId = api.userSteps().feedSteps().addDefaultFeed(client).getFeedId();
        performanceAdGroupId =
                api.userSteps().adGroupsSteps().addDefaultPerformanceGroup(performanceCampaignId, feedId);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps().clientFakeSteps().fakeClearClientSpentUnits(client.getLogin());
    }

    @Test
    public void deletePerformance() {
        var deleteRequest = new DeleteRequestMap()
                .withSelectionCriteria(new IdsCriteriaMap().withIds(performanceAdGroupId));

        api.userSteps().adGroupsSteps().shouldGetResultOnDelete(
                deleteRequest,
                ExpectedResult.success()
        );
    }
}
