package ru.yandex.autotests.direct.api.adgroups.get;

import java.util.List;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.AdGroupGetItem;
import com.yandex.direct.api.v5.adgroups.AddResponse;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import com.yandex.direct.api.v5.adgroups.SmartAdGroupAdd;
import com.yandex.direct.api.v5.adgroups.SmartAdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.SmartAdGroupGet;
import com.yandex.direct.api.v5.general.AdGroupTypesEnum;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.qatools.allure.annotations.Features;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

@Features(AdGroupsFeatures.GET)
public class GetTest {
    private static final String AD_GROUP_NAME = "name";
    private static final long REGION_ID = 1L;
    private static ClientInfo client;

    @ClassRule
    public static final ApiSteps api = new ApiSteps();

    private static Long performanceCampaignId;
    private static Long feedId;

    @BeforeClass
    public static void initTest() {
        client = api.createClient();
        api.as(client);

        performanceCampaignId = api.userSteps().campaignSteps().addDefaultSmartCampaign(client);
        feedId = api.userSteps().feedSteps().addDefaultFeed(client).getFeedId();
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps().clientFakeSteps().fakeClearClientSpentUnits(client.getLogin());
    }

    @Test
    public void getPerformanceByIdWithFeedFields() {
        var smartAdGroup = new SmartAdGroupAdd()
                .withFeedId(feedId);
        var adGroupAddItemMap = new AdGroupAddItemMap()
                .defaultAdGroupAddItem(performanceCampaignId)
                .withName(AD_GROUP_NAME)
                .withCampaignId(performanceCampaignId)
                .withRegionIds(REGION_ID)
                .withPerformanceAdGroup(smartAdGroup);
        var request = new AddRequestMap().withAdGroups(adGroupAddItemMap);
        AddResponse addResponse = api.userSteps().adGroupsSteps().adGroupsAdd(request);
        Long adGroupId = addResponse.getAddResults().get(0).getId();

        var idsSelectionCriteria = new AdGroupsSelectionCriteriaMap().withIds(adGroupId);
        var getRequest = new GetRequestMap()
                .withSelectionCriteria(idsSelectionCriteria)
                .withFieldNames(
                        AdGroupFieldEnum.ID,
                        AdGroupFieldEnum.NAME,
                        AdGroupFieldEnum.CAMPAIGN_ID,
                        AdGroupFieldEnum.TYPE,
                        AdGroupFieldEnum.REGION_IDS
                )
                .withSmartAdGroupFieldNames(SmartAdGroupFieldEnum.FEED_ID);

        GetResponse response = api.userSteps().adGroupsSteps().adGroupsGet(getRequest);
        var smartAdGroupGet = new SmartAdGroupGet()
                .withFeedId(feedId);
        var expectedAdGroup = new AdGroupGetItemMap()
                .withId(adGroupId)
                .withName(AD_GROUP_NAME)
                .withCampaignId(performanceCampaignId)
                .withType(AdGroupTypesEnum.SMART_AD_GROUP)
                .withRegionIds(REGION_ID)
                .withSmartAdGroup(smartAdGroupGet);
        List<AdGroupGetItem> adGroups = response.getAdGroups();
        assertThat("Получена одна группа", adGroups, Matchers.hasSize(1));
        assertThat("Полученная группа совпадает с ожидаемой", adGroups.get(0), beanDiffer(expectedAdGroup.getBean()));
    }

}
