package ru.yandex.autotests.direct.api.adgroups.update;

import com.yandex.direct.api.v5.adgroups.ObjectFactory;
import com.yandex.direct.api.v5.adgroups.SmartAdGroupUpdate;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.entity.adgroup.service.validation.types.PerformanceAdGroupValidation;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.qatools.allure.annotations.Features;

@Features(AdGroupsFeatures.UPDATE)
public class UpdateTest {
    private static final String FEED_TITLE = "title";
    private static final ObjectFactory FACTORY = new ObjectFactory();

    private static ClientInfo client;

    @ClassRule
    public static final ApiSteps api = new ApiSteps();

    private static Long performanceAdGroupId;

    @BeforeClass
    public static void initTest() {
        client = api.createClient();
        api.as(client);

        Long performanceCampaignId = api.userSteps().campaignSteps().addDefaultSmartCampaign(client);
        Long feedId = api.userSteps().feedSteps().addDefaultFeed(client).getFeedId();
        performanceAdGroupId =
                api.userSteps().adGroupsSteps().addDefaultPerformanceGroup(performanceCampaignId, feedId);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps().clientFakeSteps().fakeClearClientSpentUnits(client.getLogin());
    }

    @Test
    public void updatePerformanceWithValidFeedName() {
        var smartAdGroup = new SmartAdGroupUpdate()
                .withAdTitleSource(FACTORY.createSmartAdGroupGetAdTitleSource(FEED_TITLE));
        var adGroupUpdateItemMap = new AdGroupUpdateItemMap()
                .withId(performanceAdGroupId)
                .withSmartAdGroup(smartAdGroup);

        api.userSteps().adGroupsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAdGroups(adGroupUpdateItemMap),
                ExpectedResult.success()
        );
    }

    @Test
    public void updatePerformanceWithInvalidFeedBody() {
        var invalidFeedBody = "a".repeat(PerformanceAdGroupValidation.MAX_BODY_LENGTH + 1);
        var smartAdGroup = new SmartAdGroupUpdate()
                .withAdBodySource(FACTORY.createSmartAdGroupGetAdBodySource(invalidFeedBody));
        var adGroupUpdateItemMap = new AdGroupUpdateItemMap()
                .withId(performanceAdGroupId)
                .withSmartAdGroup(smartAdGroup);

        api.userSteps().adGroupsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAdGroups(adGroupUpdateItemMap),
                ExpectedResult.errors(new Notification(5001, Api5ErrorDetails.FEED_BODY_FIELD_IS_TOO_LONG,
                        PerformanceAdGroupValidation.MAX_NAME_LENGTH))
        );
    }
}
