package ru.yandex.autotests.direct.api.ads.add;

import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 06.04.15.
 * https://st.yandex-team.ru/TESTIRT-5093
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Пообъектная обработка запроса")
@Issue("https://st.yandex-team.ru/DIRECT-34558")
public class DiscreteValidationTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long textAdGroupId;
    private static Long vCardId;

    private static Long mobileAppAdGroupId;

    private static Long dynamicTextAdGroupId;

    @BeforeClass
    public static void initTest() {
        ClientInfo clientInfo = api.createClient();
        String login = clientInfo.getLogin();
        api.as(clientInfo);

        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);

        Long textCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(clientInfo);
        textAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(textCampaignId);
        vCardId = api.userSteps.vCardsSteps().addDefaultVCard(textCampaignId);

        Long mobileAppCampaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign(clientInfo);
        mobileAppAdGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(mobileAppCampaignId);

        Long dynamicTextCampaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign(clientInfo);
        dynamicTextAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(dynamicTextCampaignId);
    }

    @Test
    public void addValidAndInvalidAds() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                        .withTextAd(new TextAdAddMap().defaultTextAd())
                                        .withAdGroupId(textAdGroupId),
                                new AdAddItemMap()
                                        .withTextAd(new TextAdAddMap().defaultTextAd())
                                        .withAdGroupId(textAdGroupId + 10000)),
                ExpectedResult.success(),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND)));
    }

    @Test
    public void addInvalidAndValidAds() {
        //DIRECT-41092
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                        .withTextAd(new TextAdAddMap().defaultTextAd())
                                        .withAdGroupId(textAdGroupId + 10000),
                                new AdAddItemMap()
                                        .withTextAd(new TextAdAddMap().defaultTextAd())
                                        .withAdGroupId(textAdGroupId)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND)),
                ExpectedResult.success());
    }

    @Test
    public void addTwoInvalidAds() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                        .withTextAd(new TextAdAddMap().defaultTextAd())
                                        .withAdGroupId(textAdGroupId + 10000),
                                new AdAddItemMap()
                                        .withTextAd(new TextAdAddMap().defaultTextAd())
                                        .withAdGroupId(textAdGroupId + 10000)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND)));
    }

    @Test
    public void addTwoValidAdsWithDifferentSetsOfFields() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                        .withTextAd(new TextAdAddMap().defaultTextAd())
                                        .withAdGroupId(textAdGroupId),
                                new AdAddItemMap()
                                        .withTextAd(new TextAdAddMap()
                                                .withText(TextAdAddMap.DEFAULT_TEXT)
                                                .withTitle(TextAdAddMap.DEFAULT_TITLE)
                                                .withMobile(YesNoEnum.NO)
                                                .withVCardId(vCardId))
                                        .withAdGroupId(textAdGroupId)),
                ExpectedResult.success(), ExpectedResult.success());
    }

    @Test
    public void addMobileAppAdWithErrorAndTextAdWithNoError() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(
                                new AdAddItemMap()
                                        .withTextAd(new TextAdAddMap().defaultTextAd())
                                        .withAdGroupId(textAdGroupId),
                                new AdAddItemMap()
                                        .withMobileAppAd(new MobileAppAdAddMap().defaultMobileAppAd())
                                        .withAdGroupId(textAdGroupId)),
                ExpectedResult.success(),
                ExpectedResult.errors(new Notification(6000,
                        Api5ErrorDetails.TYPE_OF_AD_DOES_NOT_CORRESPOND_TO_GROUP)));
    }

    @Test
    public void addMobileAppAdWithNoErrorAndTextAdWithError() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(
                                new AdAddItemMap()
                                        .withTextAd(new TextAdAddMap().defaultTextAd())
                                        .withAdGroupId(mobileAppAdGroupId),
                                new AdAddItemMap()
                                        .withMobileAppAd(new MobileAppAdAddMap().defaultMobileAppAd())
                                        .withAdGroupId(mobileAppAdGroupId)),
                ExpectedResult.errors(new Notification(6000, Api5ErrorDetails.TYPE_OF_AD_DOES_NOT_CORRESPOND_TO_GROUP)),
                ExpectedResult.success());
    }

    @Test
    public void addValidDynamicTextAdAndInvalidDynamicTextAd() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                        .withDynamicTextAd(new DynamicTextAdAddMap().defaultDynamicTextAd())
                                        .withAdGroupId(dynamicTextAdGroupId),
                                new AdAddItemMap()
                                        .withDynamicTextAd(new DynamicTextAdAddMap().defaultDynamicTextAd())
                                        .withAdGroupId(dynamicTextAdGroupId + 10000)), ExpectedResult.success(),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND)));
    }

    @Test
    public void addValidDynamicTextAdAndInvalidTextAd() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                        .withDynamicTextAd(new DynamicTextAdAddMap().defaultDynamicTextAd())
                                        .withAdGroupId(dynamicTextAdGroupId),
                                new AdAddItemMap()
                                        .withTextAd(new TextAdAddMap().defaultTextAd())
                                        .withAdGroupId(dynamicTextAdGroupId)), ExpectedResult.success(),
                ExpectedResult.errors(new Notification(6000,
                        Api5ErrorDetails.TYPE_OF_AD_DOES_NOT_CORRESPOND_TO_GROUP)));
    }

    @Test
    public void addInvalidDynamicTextAdAndValidTextAd() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                        .withDynamicTextAd(new DynamicTextAdAddMap().defaultDynamicTextAd())
                                        .withAdGroupId(textAdGroupId),
                                new AdAddItemMap()
                                        .withTextAd(new TextAdAddMap().defaultTextAd())
                                        .withAdGroupId(textAdGroupId)),
                ExpectedResult.errors(new Notification(6000, Api5ErrorDetails.TYPE_OF_AD_DOES_NOT_CORRESPOND_TO_GROUP)),
                ExpectedResult.success());
    }
}
