package ru.yandex.autotests.direct.api.ads.add.smartadbuilderad;

import com.yandex.direct.api.v5.ads.AdBuilderAdAddItem;
import com.yandex.direct.api.v5.ads.SmartAdBuilderAdAdd;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.qatools.allure.annotations.Features;

@Features(AdsFeatures.ADD)
public class AddSmartAdTest {
    private static final long NON_EXISTENT_CREATIVE_ID = 39194L;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    private static ClientInfo client;
    private static Long adGroupId1;
    private static Long adGroupId2;

    @BeforeClass
    public static void initTest() {
        client = api.createClient();
        api.as(client);

        var campaignId = api.userSteps().campaignSteps().addDefaultSmartCampaign(client);
        var feedId = api.userSteps().feedSteps().addDefaultFeed(client).getFeedId();
        adGroupId1 = api.userSteps().adGroupsSteps().addDefaultPerformanceGroup(campaignId, feedId);
        adGroupId2 = api.userSteps().adGroupsSteps().addDefaultPerformanceGroup(campaignId, feedId);
    }

    @Test
    public void addOneAd() {
        var performanceCreativeId =
                api.userSteps().creativeSteps().addDefaultPerformanceCreative(client).getCreativeId();
        var itemMap = buildAdAddItemMap(adGroupId1, performanceCreativeId);
        api.userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(itemMap),
                ExpectedResult.success()
        );
    }

    @Test
    public void addTwoAdsInOneGroup() {
        var performanceCreativeId1 =
                api.userSteps().creativeSteps().addDefaultPerformanceCreative(client).getCreativeId();
        var performanceCreativeId2 =
                api.userSteps().creativeSteps().addDefaultPerformanceCreative(client).getCreativeId();
        var itemMap1 = buildAdAddItemMap(adGroupId1, performanceCreativeId1);
        var itemMap2 = buildAdAddItemMap(adGroupId1, performanceCreativeId2);
        api.userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(itemMap1, itemMap2),
                ExpectedResult.success(),
                ExpectedResult.success()
        );
    }

    @Test
    public void addTwoAdsInTwoGroups() {
        var performanceCreativeId1 =
                api.userSteps().creativeSteps().addDefaultPerformanceCreative(client).getCreativeId();
        var performanceCreativeId2 =
                api.userSteps().creativeSteps().addDefaultPerformanceCreative(client).getCreativeId();
        var itemMap1 = buildAdAddItemMap(adGroupId1, performanceCreativeId1);
        var itemMap2 = buildAdAddItemMap(adGroupId2, performanceCreativeId2);
        api.userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(itemMap1, itemMap2),
                ExpectedResult.success(),
                ExpectedResult.success()
        );
    }

    @Test
    public void addAdWithNotExistentCreative() {
        var itemMap = buildAdAddItemMap(adGroupId1, NON_EXISTENT_CREATIVE_ID);
        api.userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(itemMap),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CREATIVE_NOT_FOUND))
        );
    }

    private AdAddItemMap buildAdAddItemMap(Long adGroupId, Long performanceCreativeId) {
        var item = new AdBuilderAdAddItem().withCreativeId(performanceCreativeId);
        var smartAdBuilderAd = new SmartAdBuilderAdAdd().withCreative(item);
        return new AdAddItemMap()
                .withSmartAdBuilderAd(smartAdBuilderAd)
                .withAdGroupId(adGroupId);
    }
}
