package ru.yandex.autotests.direct.api.ads.archive;

import com.yandex.direct.api.v5.ads.ArchiveResponse;
import com.yandex.direct.api.v5.general.ActionResult;
import com.yandex.direct.api.v5.general.ExceptionNotification;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.ads.ArchiveRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerStatusModerate;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.qatools.allure.annotations.Features;

import static org.assertj.core.api.Assertions.assertThat;

@Features(AdsFeatures.ARCHIVE)
public class ArchiveSmartAdTest {

    private static final long NON_EXISTENT_AD_ID = 2294L;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    private static ClientInfo client;
    private static Long adGroupId;

    @BeforeClass
    public static void initTest() {
        client = api.createClient();
        api.as(client);

        var campaignId = api.userSteps().campaignSteps().addDefaultSmartCampaign(client);
        var feedId = api.userSteps().feedSteps().addDefaultFeed(client).getFeedId();
        adGroupId = api.userSteps().adGroupsSteps().addDefaultPerformanceGroup(campaignId, feedId);
    }

    @Test
    public void archiveAd() {
        var performanceCreativeId =
                api.userSteps().creativeSteps().addDefaultPerformanceCreative(client).getCreativeId();
        var adId = api.userSteps().adsSteps().addDefaultPerformanceAd(adGroupId, performanceCreativeId);
        api.userSteps().bannersFakeSteps().updateStatusModerate(adId, OldBannerStatusModerate.YES);
        api.userSteps().adsSteps().shouldGetResultOnArchive(
                new ArchiveRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(adId)),
                ExpectedResult.success()
        );
    }

    @Test
    public void archiveDraftAd() {
        var performanceCreativeId =
                api.userSteps().creativeSteps().addDefaultPerformanceCreative(client).getCreativeId();
        var adId = api.userSteps().adsSteps().addDefaultPerformanceAd(adGroupId, performanceCreativeId);
        api.userSteps().adsSteps().shouldGetResultOnArchive(
                new ArchiveRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(adId)),
                ExpectedResult.errors(new Notification(8300, Api5ErrorDetails.AD_CANNOT_ARCHIVE_DRAFT))
        );
    }

    @Test
    public void archiveAlreadyArchivedAd() {
        var performanceCreativeId =
                api.userSteps().creativeSteps().addDefaultPerformanceCreative(client).getCreativeId();
        var adId = api.userSteps().adsSteps().addDefaultPerformanceAd(adGroupId, performanceCreativeId);
        api.userSteps().bannersFakeSteps().updateStatusModerate(adId, OldBannerStatusModerate.YES);
        api.userSteps().adsSteps().adsArchive(adId);

        ArchiveResponse archiveResponse = api.userSteps().adsSteps().adsArchive(adId);
        ActionResult actionResult = archiveResponse.getArchiveResults().get(0);
        ExceptionNotification exceptionNotification = actionResult.getWarnings().get(0);
        assertThat(exceptionNotification.getCode()).isEqualTo(10202);
    }

    @Test
    public void archiveNonExistentAd() {
        api.userSteps().adsSteps().shouldGetResultOnArchive(
                new ArchiveRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(NON_EXISTENT_AD_ID)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND))
        );
    }
}
