package ru.yandex.autotests.direct.api.ads.delete;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.ads.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.qatools.allure.annotations.Features;

@Features(AdsFeatures.DELETE)
public class DeleteSmartAdTest {

    private static final long NON_EXISTENT_AD_ID = 2900L;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    private static Long adId;

    @BeforeClass
    public static void initTest() {
        ClientInfo client = api.createClient();
        api.as(client);

        var campaignId = api.userSteps().campaignSteps().addDefaultSmartCampaign(client);
        var feedId = api.userSteps().feedSteps().addDefaultFeed(client).getFeedId();
        var adGroupId = api.userSteps().adGroupsSteps().addDefaultPerformanceGroup(campaignId, feedId);
        var performanceCreativeId =
                api.userSteps().creativeSteps().addDefaultPerformanceCreative(client).getCreativeId();
        adId = api.userSteps().adsSteps().addDefaultPerformanceAd(adGroupId, performanceCreativeId);
    }

    @Test
    public void deleteAd() {
        api.userSteps().adsSteps().shouldGetResultOnDelete(
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(adId)),
                ExpectedResult.success()
        );
    }


    @Test
    public void deleteNonExistentAd() {
        api.userSteps().adsSteps().shouldGetResultOnDelete(
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(NON_EXISTENT_AD_ID)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND))
        );
    }
}
