package ru.yandex.autotests.direct.api.ads.moderate;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 17.04.15.
 * https://st.yandex-team.ru/TESTIRT-5223
 */
@Aqua.Test
@Features(AdsFeatures.MODERATE)
@Description("Id, которые должны вызывать ошибку")
@Issue("https://st.yandex-team.ru/DIRECT-40261")
public class IdsNegativeTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private ClientInfo clientInfo;
    private String client;
    private ClientInfo anotherClientInfo;
    private String anotherClient;

    private Long campaignId;
    private Long adGroupId;
    private Long id;

    @Before
    public void createAd() {
        clientInfo = api.createClient();
        client = clientInfo.getLogin();
        anotherClientInfo = api.createClient();
        anotherClient = anotherClientInfo.getLogin();

        api.as(clientInfo);

        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(anotherClient);

        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        id = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
    }

    @Test
    public void moderateZeroId() {
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(0L),
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND)));
    }

    @Test
    public void moderateNotMyId() {
        api.as(anotherClientInfo);
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(id),
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND)));
    }

    @Test
    public void moderateDeletedId() {
        api.userSteps.adsSteps().adsDelete(id);
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(id),
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND)));
    }

//    @Test
//    public void moderateIdFromDeletedCampaign() {
//        api.userSteps.campaignSteps().campaignsDelete(campaignId);
//        api.userSteps.adsSteps()
//                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(id),
//                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND)));
//    }
//
//    @Test
//    public void moderateArchivedId() {
//        api.userSteps.adsSteps().adsModerate(id);
//        api.userSteps.adsSteps().adsArchive(id);
//        api.userSteps.adsSteps()
//                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(id),
//                        ExpectedResult.errors(new Notification(8300, Api5ErrorDetails
//                        .AD_IS_ARCHIVED_AND_CANT_BE_MODERATED)));
//    }
//
//    @Test
//    public void moderateIdFromArchivedCampaign() {
//        //DIRECT-41160
//        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
//        api.userSteps.campaignFakeSteps().setLastShowTimeAnHourAndMinuteAgo(campaignId);
//        api.userSteps.campaignSteps().campaignsSuspend(campaignId);
//        api.userSteps.campaignSteps().campaignsArchive(campaignId);
//        List<CampaignGetItem> campaignResponse = api.userSteps.campaignSteps().getCampaigns(
//                new GetRequestMap()
//                        .withSelectionCriteria(
//                                new CampaignsSelectionCriteriaMap()
//                                        .withIds(campaignId).withStates(CampaignStateEnum.ARCHIVED))
//                        .withFieldNames(CampaignFieldEnum.ID));
//        assumeThat("кампания заархивировалась", campaignResponse, beanDifferV5(
//                Arrays.asList((CampaignGetItem) new CampaignGetItemMap().setId(campaignId).getBean())
//        ));
//        api.userSteps.adsSteps()
//                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(id),
//                        ExpectedResult.errors(
//                                new Notification(8300, Api5ErrorDetails.UNABLE_UPDATE_ARCHIVED_CAMPAGN)));
//    }

    @Test
    public void moderateNonExistentId() {
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(id + 100000),
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND)));
    }

    @Test
    public void moderateNegativeId() {
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(-id),
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND)));
    }
}
