package ru.yandex.autotests.direct.api.ads.moderate;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.ModerateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 14.09.15.
 * https://st.yandex-team.ru/TESTIRT-6853
 */
@Aqua.Test
@Features(AdsFeatures.MODERATE)
@Description("Проверка модерации объявлений разных типов в одном запросе")
@Issue("https://st.yandex-team.ru/DIRECT-44779")
public class ModerateAdsOfDifferentTypesTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static long textAdGroupId;
    private static long mobileAppAdGroupId;
//    private static long dynamicTextAdGroupId;
    private static String adImageHash;

    private static String login;
    private static ClientInfo client;

    @BeforeClass
    public static void createAdGroup() {
        client = api.createClient();
        login = client.getLogin();
        api.as(client);

        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);

        Long textCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        textAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(textCampaignId);
        api.userSteps.keywordsSteps().addDefaultKeyword(textAdGroupId);

        Long mobileCampaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        mobileAppAdGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(mobileCampaignId);
        api.userSteps.keywordsSteps().addDefaultKeyword(mobileAppAdGroupId);

//        Long dynamicTextCampaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
//        dynamicTextAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(dynamicTextCampaignId);
//        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(dynamicTextAdGroupId);

        adImageHash = api.userSteps.imagesStepsV5().addImageAdAdImage(3);
    }

    private long textAdId;
    private long mobileAppAdId;
//    private long textImageAdId;
//    private long mobileAppImageAdId;
//    private long dynamicTextAdId;

    @Before
    @Step("Подготовка данных для теста")
    public void createAds() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);

        textAdId = api.userSteps.adsSteps().addDefaultTextAd(textAdGroupId);
        mobileAppAdId = api.userSteps.adsSteps().addDefaultMobileAppAd(mobileAppAdGroupId);
//        textImageAdId = api.userSteps.adsSteps().addDefaultTextImageAd(textAdGroupId, adImageHash);
//        mobileAppImageAdId = api.userSteps.adsSteps().addDefaultMobileAppImageAd(mobileAppAdGroupId, adImageHash);
//        dynamicTextAdId = api.userSteps.adsSteps().addDefaultDynamicTextAd(dynamicTextAdGroupId);
    }

    @Test
    @Description("Модерация текстового объявления и объявления РМП за один запрос")
    public void moderateTextAdAndMobileAppAd() {
        api.userSteps.adsSteps().shouldGetResultOnModerate(new ModerateRequestMap()
                        .withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(textAdId, mobileAppAdId)),
                ExpectedResult.success(), ExpectedResult.success());
    }

    @Test
    @Ignore("Пока нет поддержки dynamicTextAdTargets.add")
    @Description("Модерация текстового объявления и динамического текстового объявления за один запрос")
    public void moderateTextAdAndDynamicTextAd() {
//        api.userSteps.adsSteps().shouldGetResultOnModerate(new ModerateRequestMap()
//                        .withSelectionCriteria(new IdsCriteriaMap()
//                                .withIds(textAdId, dynamicTextAdId)),
//                ExpectedResult.success(), ExpectedResult.success());
    }

    @Test
    @Ignore("Пока нет поддержки dynamicTextAdTargets.add")
    @Description("Модерация текстового объявления, графического объявления, динамического текстового объявления, объявления РМП и графического объявления РМП за один запрос")
    public void moderateTextAdAndTextImageAdAndDynamicTextAdAndMobileAppAdAndMobileAppImageAd() {
//        api.userSteps.adsSteps().shouldGetResultOnModerate(new ModerateRequestMap()
//                        .withSelectionCriteria(new IdsCriteriaMap()
//                                .withIds(textAdId, textImageAdId, dynamicTextAdId, mobileAppAdId, mobileAppImageAdId)),
//                ExpectedResult.success(), ExpectedResult.success(), ExpectedResult.success(), ExpectedResult.success(), ExpectedResult.success());
    }
}
