package ru.yandex.autotests.direct.api.ads.moderate;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.enums.DirectObjectType;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 17.04.15.
 * https://st.yandex-team.ru/TESTIRT-5223
 */
@Aqua.Test
@Features(AdsFeatures.MODERATE)
@Description("Отправка на модерацию одного или нескольких баннеров")
@Issue("https://st.yandex-team.ru/DIRECT-40261")
@RunWith(Parameterized.class)
public class ModerateAdsTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static ClientInfo clientInfo;

    Long campaignId;
    Long adId1;
    Long adId2;

    @Parameterized.Parameter(0)
    public DirectObjectType type;

    @Parameterized.Parameters(name = "type = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {DirectObjectType.TEXT},
                {DirectObjectType.MOBILE_CONTENT},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initTest() {
        clientInfo = api.createClient();
        String login = clientInfo.getLogin();
        api.as(clientInfo);

        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);
    }

    @Before
    public void createObjects() {
        campaignId = api.userSteps.campaignSteps().addDefaultCampaign(clientInfo, type.getCampaignType());
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, type.getAdGroupType());
        adId1 = api.userSteps.adsSteps().addDefaultAd(adGroupId, type.getBannerType());
        adId2 = api.userSteps.adsSteps().addDefaultAd(adGroupId, type.getBannerType());
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId1);
        assumeThat("баннер является черновиком", bannerFakeInfo.getStatusModerate(), equalTo(Status.NEW));
        bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId2);
        assumeThat("баннер является черновиком", bannerFakeInfo.getStatusModerate(), equalTo(Status.NEW));
    }

    @Test
    public void moderateOneAdTest() {
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId1), ExpectedResult.success(adId1));
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId1);
        assertThat("баннер отправился на модерцию", bannerFakeInfo.getStatusModerate(), equalTo(Status.READY));
    }

    @Test
    public void moderateTwoAdsTest() {
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId1, adId2),
                        ExpectedResult.success(adId1), ExpectedResult.success(adId2));
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId1);
        assertThat("баннер отправился на модерцию", bannerFakeInfo.getStatusModerate(), equalTo(Status.READY));
        bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId2);
        assertThat("баннер отправился на модерцию", bannerFakeInfo.getStatusModerate(), equalTo(Status.READY));
    }
}
