package ru.yandex.autotests.direct.api.ads.moderate;

import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.core.entity.creative.model.CreativeType;
import ru.yandex.direct.core.entity.creative.model.StatusModerate;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.qatools.allure.annotations.Features;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.direct.core.testing.data.TestCreatives.defaultPerformanceCreative;

@Features(AdsFeatures.MODERATE)
public class ModerateSmartAdTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps();

    private static ClientInfo clientInfo;
    private static Long adId;
    private static Long creativeId;

    @BeforeClass
    public static void initTest() {
        clientInfo = api.createClient();
        api.as(clientInfo);
        api.userSteps().clientFakeSteps().fakeClearClientSpentUnits(clientInfo.getLogin());

        Long campaignId = api.userSteps().campaignSteps().addDefaultSmartCampaign(clientInfo);
        var feedId = api.userSteps().feedSteps().addDefaultFeed(clientInfo).getFeedId();
        var adGroupId = api.userSteps().adGroupsSteps().addDefaultPerformanceGroup(campaignId, feedId);
        api.userSteps().performanceFilterSteps().addDefaultBidsPerformance(adGroupId);
        var creative = defaultPerformanceCreative(null, null).withStatusModerate(StatusModerate.NEW);
        var creativeInfo = api.userSteps().creativeSteps().addDefaultPerformanceCreative(clientInfo, creative);
        creativeId = creativeInfo.getCreativeId();
        adId = api.userSteps.adsSteps().addDefaultPerformanceAd(adGroupId, creativeId);
        var bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assumeThat("баннер является черновиком", bannerFakeInfo.getStatusModerate(), equalTo(Status.NEW));
    }

    @Test
    public void moderateOneAdTest() {
        api.userSteps().adsSteps().shouldGetResultOnModerate(
                new IdsCriteriaMap().withIds(adId),
                ExpectedResult.success(adId)
        );
        BannerFakeInfo bannerFakeInfo = api.userSteps().bannersFakeSteps().getBannerParams(adId);
        assertThat("баннер автоматически промодерирован", bannerFakeInfo.getStatusModerate(), equalTo(Status.YES));
        List<Creative> creatives = api.userSteps().creativeSteps().getCreatives(clientInfo,
                List.of(creativeId),
                List.of(CreativeType.PERFORMANCE)
        );
        Creative creative = creatives.get(0);
        assertThat("креатив отправился на модерцию", creative.getStatusModerate(), equalTo(StatusModerate.READY));
    }
}
