package ru.yandex.autotests.direct.api.ads.suspend;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.ads.SuspendRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerStatusModerate;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.qatools.allure.annotations.Features;

@Features(AdsFeatures.SUSPEND)
public class SuspendSmartAdTest {

    private static final long NON_EXISTENT_AD_ID = 2294L;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    private static ClientInfo client;
    private static Long adGroupId;

    @BeforeClass
    public static void initTest() {
        client = api.createClient();
        api.as(client);

        var campaignId = api.userSteps().campaignSteps().addDefaultSmartCampaign(client);
        var feedId = api.userSteps().feedSteps().addDefaultFeed(client).getFeedId();
        adGroupId = api.userSteps().adGroupsSteps().addDefaultPerformanceGroup(campaignId, feedId);
    }

    @Test
    public void suspendAd() {
        var performanceCreativeId =
                api.userSteps().creativeSteps().addDefaultPerformanceCreative(client).getCreativeId();
        var adId = api.userSteps().adsSteps().addDefaultPerformanceAd(adGroupId, performanceCreativeId);
        api.userSteps().bannersFakeSteps().updateStatusModerate(adId, OldBannerStatusModerate.YES);
        api.userSteps().adsSteps().shouldGetResultOnSuspend(
                new SuspendRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(adId)),
                ExpectedResult.success()
        );
    }

    @Test
    public void suspendArchivedAd() {
        var performanceCreativeId =
                api.userSteps().creativeSteps().addDefaultPerformanceCreative(client).getCreativeId();
        var adId = api.userSteps().adsSteps().addDefaultPerformanceAd(adGroupId, performanceCreativeId);
        api.userSteps().bannersFakeSteps().updateStatusModerate(adId, OldBannerStatusModerate.YES);
        api.userSteps().adsSteps().adsArchive(adId);
        api.userSteps().adsSteps().shouldGetResultOnSuspend(
                new SuspendRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(adId)),
                ExpectedResult.errors(new Notification(8300, Api5ErrorDetails.AD_CANNOT_SUSPEND_ARCHIVED))
        );
    }

    @Test
    public void suspendNonExistentAd() {
        api.userSteps().adsSteps().shouldGetResultOnSuspend(
                new SuspendRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(NON_EXISTENT_AD_ID)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND))
        );
    }
}
