package ru.yandex.autotests.direct.api.ads.unarchive;

import com.yandex.direct.api.v5.ads.UnarchiveResponse;
import com.yandex.direct.api.v5.general.ActionResult;
import com.yandex.direct.api.v5.general.ExceptionNotification;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.ads.UnarchiveRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerStatusModerate;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.qatools.allure.annotations.Features;

import static org.assertj.core.api.Assertions.assertThat;

@Features(AdsFeatures.UNARCHIVE)
public class UnarchiveSmartAdTest {

    private static final long NON_EXISTENT_AD_ID = 2900L;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    private static ClientInfo client;
    private static Long adGroupId;

    @BeforeClass
    public static void initTest() {
        client = api.createClient();
        api.as(client);

        var campaignId = api.userSteps().campaignSteps().addDefaultSmartCampaign(client);
        var feedId = api.userSteps().feedSteps().addDefaultFeed(client).getFeedId();
        adGroupId = api.userSteps().adGroupsSteps().addDefaultPerformanceGroup(campaignId, feedId);
    }

    @Test
    public void unarchiveAd() {
        var performanceCreativeId =
                api.userSteps().creativeSteps().addDefaultPerformanceCreative(client).getCreativeId();
        var adId = api.userSteps().adsSteps().addDefaultPerformanceAd(adGroupId, performanceCreativeId);
        api.userSteps().bannersFakeSteps().updateStatusModerate(adId, OldBannerStatusModerate.YES);
        api.userSteps().adsSteps().adsArchive(adId);

        api.userSteps().adsSteps().shouldGetResultOnUnarchive(
                new UnarchiveRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(adId)),
                ExpectedResult.success()
        );
    }

    @Test
    public void unarchiveNotArchiveAd() {
        var performanceCreativeId =
                api.userSteps().creativeSteps().addDefaultPerformanceCreative(client).getCreativeId();
        var adId = api.userSteps().adsSteps().addDefaultPerformanceAd(adGroupId, performanceCreativeId);
        api.userSteps().bannersFakeSteps().updateStatusModerate(adId, OldBannerStatusModerate.YES);
        UnarchiveResponse unarchiveResponse = api.userSteps().adsSteps().adsUnarchive(adId);
        ActionResult actionResult = unarchiveResponse.getUnarchiveResults().get(0);
        ExceptionNotification exceptionNotification = actionResult.getWarnings().get(0);
        assertThat(exceptionNotification.getCode()).isEqualTo(10203);
    }

    @Test
    public void unarchiveNonExistentAd() {
        api.userSteps().adsSteps().shouldGetResultOnUnarchive(
                new UnarchiveRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(NON_EXISTENT_AD_ID)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND))
        );
    }
}
