package ru.yandex.autotests.direct.api.ads.update.smartadbuilderad;

import com.yandex.direct.api.v5.ads.AdBuilderAdUpdateItem;
import com.yandex.direct.api.v5.ads.SmartAdBuilderAdUpdate;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.qatools.allure.annotations.Features;

@Features(AdsFeatures.UPDATE)
public class UpdateSmartAdBuilderAdTest {
    private static final long NON_EXISTENT_CREATIVE_ID = 39194L;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    private static ClientInfo client;
    private static Long adId;

    @BeforeClass
    public static void initTest() {
        client = api.createClient();
        api.as(client);

        var campaignId = api.userSteps().campaignSteps().addDefaultSmartCampaign(client);
        var feedId = api.userSteps().feedSteps().addDefaultFeed(client).getFeedId();
        var adGroupId = api.userSteps().adGroupsSteps().addDefaultPerformanceGroup(campaignId, feedId);
        var performanceCreativeId =
                api.userSteps().creativeSteps().addDefaultPerformanceCreative(client).getCreativeId();
        adId = api.userSteps().adsSteps().addDefaultPerformanceAd(adGroupId, performanceCreativeId);
    }

    @Test
    public void updateWithCreative() {
        var newCreativeId =
                api.userSteps().creativeSteps().addDefaultPerformanceCreative(client).getCreativeId();
        var itemMap = buildAdUpdateItemMap(adId, newCreativeId);
        api.userSteps.adsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAds(itemMap),
                ExpectedResult.success()
        );
    }

    @Test
    public void updateAdWithNotExistentCreative() {
        var itemMap = buildAdUpdateItemMap(adId, NON_EXISTENT_CREATIVE_ID);
        api.userSteps.adsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAds(itemMap),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CREATIVE_NOT_FOUND))
        );
    }

    private AdUpdateItemMap buildAdUpdateItemMap(Long adId, Long creativeId) {
        var item = new AdBuilderAdUpdateItem().withCreativeId(creativeId);
        var smartAdBuilderAd = new SmartAdBuilderAdUpdate().withCreative(item);
        return new AdUpdateItemMap()
                .withId(adId)
                .withSmartAdBuilderAd(smartAdBuilderAd);
    }
}
