package ru.yandex.autotests.direct.api.bidmodifiers.add.smart;

import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.SmartAdAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.general.MultiIdsExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.qatools.allure.annotations.Features;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.startsWith;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Features(BidModifiersFeatures.ADD)
public class AddBidModifierSmartTest {

    private static final int MIN_BID_MODIFIER_VALUE = 20;
    private static final String ID_PREFIX = "15";

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    private static Long campaignId;
    private static Long feedId;

    @BeforeClass
    public static void initTest() {
        ClientInfo clientInfo = api.createClient();
        api.as(clientInfo);

        api.userSteps().clientFakeSteps().fakeClearClientSpentUnits(clientInfo);
        campaignId = api.userSteps().campaignSteps().addDefaultSmartCampaign(clientInfo);
        feedId = api.userSteps().feedSteps().addDefaultFeed(clientInfo).getFeedId();
    }

    @Test
    public void addToAdGroup() {
        Long adGroupId = api.userSteps().adGroupsSteps().addDefaultPerformanceGroup(campaignId, feedId);
        api.userSteps().bidModifiersSteps().shouldGetResultOnAdd(
                new BidModifierAddMap()
                        .withSmartAdAdjustment(new SmartAdAdjustmentMap().withBidModifier(25))
                        .withAdGroupId(adGroupId),
                MultiIdsExpectedResult.success()
        );
    }

    @Test
    public void addToCampaign() {
        api.userSteps().bidModifiersSteps().shouldGetResultOnAdd(
                new BidModifierAddMap()
                        .withSmartAdAdjustment(new SmartAdAdjustmentMap().withBidModifier(25))
                        .withCampaignId(campaignId),
                MultiIdsExpectedResult.success()
        );
    }

    @Test
    public void addWithCorrectPrefix() {
        Long adGroupId = api.userSteps().adGroupsSteps().addDefaultPerformanceGroup(campaignId, feedId);
        List<Long> bmIds = api.userSteps().bidModifiersSteps().bidModifiersAdd(new BidModifierAddMap()
                .withSmartAdAdjustment(new SmartAdAdjustmentMap()
                        .withBidModifier(25))
                .withAdGroupId(adGroupId));
        assumeThat("добавлена смарт корректировка ставки для группы", bmIds, hasSize(1));

        assertThat("идентификатор смарт корректировки ставки начинается с корректного префикса",
                String.valueOf(bmIds.get(0)), startsWith(ID_PREFIX));
    }

    @Test
    public void addWithInvalidValue() {
        Long adGroupId = api.userSteps().adGroupsSteps().addDefaultPerformanceGroup(campaignId, feedId);
        api.userSteps().bidModifiersSteps().shouldGetResultOnAdd(
                new BidModifierAddMap()
                        .withSmartAdAdjustment(new SmartAdAdjustmentMap().withBidModifier(19))
                        .withAdGroupId(adGroupId),
                MultiIdsExpectedResult.errors(new Notification(5005, Api5ErrorDetails.BID_MODIFIER_MUST_BE_GREATER,
                        MIN_BID_MODIFIER_VALUE))
        );
    }
}
