package ru.yandex.autotests.direct.api.bidmodifiers.delete.smart;

import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.SmartAdAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.qatools.allure.annotations.Features;

@Features(BidModifiersFeatures.DELETE)
public class DeleteBidModifierSmartTest {
    private static final long NON_EXISTENT_BID_MODIFIER_ID = 29002L;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    private static Long campaignId;
    private static Long feedId;

    @BeforeClass
    public static void initTest() {
        ClientInfo clientInfo = api.createClient();
        api.as(clientInfo);

        api.userSteps().clientFakeSteps().fakeClearClientSpentUnits(clientInfo);
        campaignId = api.userSteps().campaignSteps().addDefaultSmartCampaign(clientInfo);
        feedId = api.userSteps().feedSteps().addDefaultFeed(clientInfo).getFeedId();
    }

    @Test
    public void deleteFromAdGroup() {
        Long adGroupId = api.userSteps().adGroupsSteps().addDefaultPerformanceGroup(campaignId, feedId);
        List<Long> bmIds = addToAdGroup(adGroupId);

        api.userSteps().bidModifiersSteps().shouldGetResultOnDelete(
                bmIds,
                ExpectedResult.success()
        );
    }

    @Test
    public void deleteWithNonExistentId() {
        api.userSteps().adGroupsSteps().addDefaultPerformanceGroup(campaignId, feedId);
        api.userSteps().bidModifiersSteps().shouldGetResultOnDelete(
                List.of(NON_EXISTENT_BID_MODIFIER_ID),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.BID_MODIFIER_NOT_FOUND))
        );
    }

    private List<Long> addToAdGroup(Long adGroupId) {
        return api.userSteps().bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withSmartAdAdjustment(new SmartAdAdjustmentMap().withBidModifier(25))
                        .withAdGroupId(adGroupId)
        );
    }
}
