package ru.yandex.autotests.direct.api.bidmodifiers.set.smart;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.autotests.direct.api.bidmodifiers.BidModifiersFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierSetMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.SmartAdAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.qatools.allure.annotations.Features;

@Features(BidModifiersFeatures.SET)
public class SetBidModifierSmartTest {
    private static final int MIN_BID_MODIFIER_VALUE = 20;
    private static final long NON_EXISTENT_BID_MODIFIER_ID = 29002L;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    private static Long bmId;

    @BeforeClass
    public static void initTest() {
        ClientInfo clientInfo = api.createClient();
        api.as(clientInfo);

        api.userSteps().clientFakeSteps().fakeClearClientSpentUnits(clientInfo);
        var campaignId = api.userSteps().campaignSteps().addDefaultSmartCampaign(clientInfo);
        var feedId = api.userSteps().feedSteps().addDefaultFeed(clientInfo).getFeedId();
        var adGroupId = api.userSteps().adGroupsSteps().addDefaultPerformanceGroup(campaignId, feedId);
        bmId = api.userSteps().bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withSmartAdAdjustment(new SmartAdAdjustmentMap().withBidModifier(25))
                        .withAdGroupId(adGroupId)
        ).get(0);
    }

    @Test
    public void setWithValidValue() {
        api.userSteps().bidModifiersSteps().shouldGetResultOnSet(
                new BidModifierSetMap().withId(bmId).withBidModifier(30),
                ExpectedResult.success()
        );
    }

    @Test
    public void setWithValidValueToNonExistentId() {
        api.userSteps().bidModifiersSteps().shouldGetResultOnSet(
                new BidModifierSetMap().withId(NON_EXISTENT_BID_MODIFIER_ID).withBidModifier(30),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.BID_MODIFIER_NOT_FOUND))
        );
    }

    @Test
    public void setWithInvalidValue() {
        api.userSteps().bidModifiersSteps().shouldGetResultOnSet(
                new BidModifierSetMap().withId(bmId).withBidModifier(10),
                ExpectedResult.errors(new Notification(5005, Api5ErrorDetails.BID_MODIFIER_MUST_BE_GREATER,
                        MIN_BID_MODIFIER_VALUE))
        );
    }
}
