package ru.yandex.autotests.direct.api.campaigns.add.dynamictextcampaign;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignsSelectionCriteria;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import com.yandex.direct.api.v5.general.AttributionModelEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pashkus on 5.09.19.
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-99821")
@Features(CampaignsFeatures.ADD)
@Description("Проверка поля AttributionModel")
@RunWith(Parameterized.class)
public class AttributionModelAddAndGetTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @Parameterized.Parameter(0)
    public AttributionModelEnum initialAttributionModel;
    private Long campaignId;

    @Parameterized.Parameters(name = "AttributionModel = {0}")
    public static Collection<?> testData() {
        Object[][] data = new Object[][]{
                {AttributionModelEnum.FC},
                {AttributionModelEnum.LC},
                {AttributionModelEnum.LSC},
                {AttributionModelEnum.LYDC},
                {AttributionModelEnum.FCCD},
                {AttributionModelEnum.LSCCD},
                {AttributionModelEnum.LYDCCD},
                {null},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initTest() {
        ClientInfo client = api.createClient();
        api.as(client);
    }

    @Before
    public void prepare() {
        campaignId = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                                .defaultDynamicTextCampaign()
                                .withAttributionModel(initialAttributionModel)));
    }

    @Test
    public void checkCampaignAttributionModel() {

        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap().withSelectionCriteria(
                                new CampaignsSelectionCriteria()
                                        .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withDynamicTextCampaignFieldNames(DynamicTextCampaignFieldEnum.ATTRIBUTION_MODEL));

        assumeThat("получили созданную кампанию", getResponse.getCampaigns(), hasSize(1));
        AttributionModelEnum attributionModel =
                getResponse.getCampaigns().get(0).getDynamicTextCampaign().getAttributionModel();
        assumeThat("получили attributionModel", attributionModel, notNullValue());

        assertThat("модель атрибуции соответствует ожиданиям", attributionModel,
                equalTo((initialAttributionModel != null) ? initialAttributionModel : AttributionModelEnum.LYDCCD));
    }

}
