package ru.yandex.autotests.direct.api.campaigns.add.dynamictextcampaign;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

/**
 * Created by pavryabov on 19.11.15.
 * https://st.yandex-team.ru/TESTIRT-7756
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка валидации поля CounterIds. Негативные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-44876")
@RunWith(Parameterized.class)
public class CounterIdsValidationNegativeTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().asUnknownClient();

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public Integer[] counterIds;

    @Parameterized.Parameter(2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<?> testData() {
        List<Integer> overLengthCounterIds = new ArrayList<Integer>();
        for (int i = 0; i <= DynamicTextCampaignAddItemMap.MAX_AMOUNT_OF_COUNTER_IDS; i++) {
            overLengthCounterIds.add(1 + i * 100); // целые положительные разные числа
        }
        Object[][] data = new Object[][]{
                {"negative id", new Integer[]{-1}, ExpectedResult.errorsIgnoringDetails(
                        new Notification(5005, Api5ErrorDetails.ADDITIONAL_METRICA_COUNTERS_INCORRECTLY_SPECIFIED,
                                "-1"))},
                {"zero id", new Integer[]{0}, ExpectedResult.errorsIgnoringDetails(
                        new Notification(5005, Api5ErrorDetails.ADDITIONAL_METRICA_COUNTERS_INCORRECTLY_SPECIFIED,
                                "0"))},
                {"повторяющееся значение", new Integer[]{1, 1},
                        ExpectedResult.errorsIgnoringDetails(
                                new Notification(9802, Api5ErrorDetails.ELEMENT_PRESENT_IN_LIST_MORE_THAN_ONE_TIME,
                                        1, "CounterIds"),
                                new Notification(9802, Api5ErrorDetails.ELEMENT_PRESENT_IN_LIST_MORE_THAN_ONE_TIME,
                                        1, "CounterIds")
                        )},
                {"Количество элементов, превышающее максимальную длину", overLengthCounterIds.toArray(new Integer[]{}),
                        ExpectedResult.errorsIgnoringDetails(
                                new Notification(7001,
                                        Api5ErrorDetails.NO_MORE_MERTRICA_COUNTERS_CAN_BE_SPECIFIED,
                                        DynamicTextCampaignAddItemMap.MAX_AMOUNT_OF_COUNTER_IDS))
                },
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("126")
    public void addWithCounterIds() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                                        .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                                .defaultDynamicTextCampaignStrategy())
                                        .withCounterIds(counterIds))
                        ),
                expectedResult);
    }
}
