package ru.yandex.autotests.direct.api.campaigns.add.dynamictextcampaign;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.CampaignsSelectionCriteria;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignGetItem;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.general.ArrayOfInteger;
import org.apache.commons.lang3.RandomUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.common.db.PpcPropertyNames;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 18.11.15.
 * https://st.yandex-team.ru/TESTIRT-7756
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка валидации поля CounterIds. Позитивные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-44876")
@RunWith(Parameterized.class)
public class CounterIdsValidationPositiveTest {
    private static final ObjectFactory objectFactory = new ObjectFactory();
    @ClassRule
    public static ApiSteps api = new ApiSteps().asUnknownClient();

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public Integer[] counterIds;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        Integer counterId = RandomUtils.nextInt(1, 1000000);
        Set<Integer> maxLengthCounterIds = new HashSet<>();
        while (maxLengthCounterIds.size() < DynamicTextCampaignAddItemMap.MAX_AMOUNT_OF_COUNTER_IDS) {
            maxLengthCounterIds.add(RandomUtils.nextInt(1, 1000000));
        }
        return Arrays.asList(new Object[][]{
                {String.valueOf(counterId), new Integer[]{counterId}},
                {"Максимальное количество элементов", maxLengthCounterIds.toArray(new Integer[]{})},
        });
    }

    @BeforeClass
    public static void prepareData() {
        api.userSteps().ppcPropertiesSteps().set(PpcPropertyNames.CROSS_DEVICE_DEFAULT_ATTRIBUTION_TYPE_ENABLED, true);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("127")
    public void addWithCounterIdsAndCheckSave() {
        //DIRECT-45955
        //DIRECT-45953
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                                        .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                                .defaultDynamicTextCampaignStrategy())
                                        .withCounterIds(counterIds))

                        ),
                ExpectedResult.success());
        Long id = addResponse.getAddResults().get(0).getId();
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new CampaignsSelectionCriteria().withIds(id))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withDynamicTextCampaignFieldNames(DynamicTextCampaignFieldEnum.COUNTER_IDS));
        assumeThat("вернулась 1 кампания", getResponse.getCampaigns(), hasSize(1));
        CampaignGetItem campaignGetItem = getResponse.getCampaigns().get(0);
        var counterIdsArray = objectFactory.createDynamicTextCampaignBaseCounterIds(
                new ArrayOfInteger().withItems(counterIds));
        assertThat("поле CounterIds сохранилось верно", campaignGetItem,
                beanDifferV5(new CampaignGetItem()
                        .withId(id)
                        .withDynamicTextCampaign(new DynamicTextCampaignGetItem()
                                .withCounterIds(counterIdsArray))));
    }
}
