package ru.yandex.autotests.direct.api.campaigns.add.dynamictextcampaign.settings;

import java.util.Arrays;
import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSetting;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSettingsEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.direct.dbschema.ppc.enums.CampaignsStatusbehavior;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка не поддерживаемых значений поля Settings в мобильных кампаниях")
@RunWith(Parameterized.class)
@ParametersAreNonnullByDefault
public class AddDeprecatedSettingsTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps();
    private static ClientInfo client;

    @Parameterized.Parameter
    public DynamicTextCampaignSettingsEnum option;

    @Parameterized.Parameter(1)
    public YesNoEnum settingValue;

    @Parameterized.Parameters(name = "option = {0}, value = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                // DIRECT-69528
                {DynamicTextCampaignSettingsEnum.ENABLE_BEHAVIORAL_TARGETING, YesNoEnum.NO},
                {DynamicTextCampaignSettingsEnum.ENABLE_BEHAVIORAL_TARGETING, YesNoEnum.YES}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareData() {
        client = api.createClient();
        api.as(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("146")
    public void checkSettingsTest() {
        AddResponse response = api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(
                        new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                                        .defaultDynamicTextCampaign()
                                        .withSettings(new DynamicTextCampaignSetting()
                                                .withOption(option)
                                                .withValue(settingValue)))),
                ExpectedResult.warningsIgnoringDetailsAndMessage(
                        new Notification(10163, Api5ErrorDetails.CAMPAIGN_SETTING_DEPRECATED, option)));

        Long campaignID = response.getAddResults().get(0).getId();

        CampaignsStatusbehavior statusBehavior =
                api.userSteps.getDirectJooqDbSteps().useShardForClient(client).getContext()
                        .select(CAMPAIGNS.STATUS_BEHAVIOR)
                        .from(CAMPAIGNS)
                        .where(CAMPAIGNS.CID.eq(campaignID))
                        .fetchSingle()
                        .value1();
        assertThat("кампания создалась с правильным значением настройки", statusBehavior,
                equalTo(CampaignsStatusbehavior.Yes));
    }
}
