package ru.yandex.autotests.direct.api.campaigns.add.dynamictextcampaign.settings;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignsSelectionCriteria;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSetting;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSettingGet;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSettingsEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSettingsGetEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.testing.data.TestRoleRelation;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Issues;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 19.11.15.
 * https://st.yandex-team.ru/TESTIRT-7756
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-44876")
@Features(CampaignsFeatures.ADD)
@Description("Проверка настройки REQUIRE_SERVICING поля Settings")
@RunWith(Parameterized.class)
public class AddManagerAssistanceTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @Parameterized.Parameter()
    public TestRoleRelation roleRelation;
    @Parameterized.Parameter(1)
    public YesNoEnum settingValue;
    @Parameterized.Parameter(2)
    public YesNoEnum expectedValue;
    private ClientInfo client;
    private Long campaignID;

    @Parameterized.Parameters(name = "roles = {0}, value = {1}")
    public static Collection<?> testData() {
        Object[][] data = new Object[][]{
                {TestRoleRelation.IDM_PRIMARY_MANAGER_AND_CLIENT, YesNoEnum.NO, YesNoEnum.NO},
                {TestRoleRelation.IDM_PRIMARY_MANAGER_AND_CLIENT, YesNoEnum.YES, YesNoEnum.YES},
                {TestRoleRelation.CLIENT_CHIEF_AND_SAME_CLIENT, YesNoEnum.NO, YesNoEnum.NO},
                {TestRoleRelation.CLIENT_CHIEF_AND_SAME_CLIENT, YesNoEnum.YES, YesNoEnum.NO}
        };
        return Arrays.asList(data);
    }

    @Before
    public void addCampaign() {
        client = api.coreSteps().rolesSteps().getRoleRelationInfo(roleRelation).getOwnerClientInfo();
        campaignID = api.as(client).userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                                .defaultDynamicTextCampaign()
                                .withSettings(new DynamicTextCampaignSetting()
                                        .withOption(DynamicTextCampaignSettingsEnum.REQUIRE_SERVICING)
                                        .withValue(settingValue))));
    }

    @Test
    @Issues({
            @Issue("https://st.yandex-team.ru/DIRECT-45669"),
            @Issue("https://st.yandex-team.ru/DIRECT-47031")
    })
    @ru.yandex.qatools.allure.annotations.TestCaseId("129")
    public void checkSettings() {
        GetResponse getResponse = api.as(client).userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new CampaignsSelectionCriteria()
                                .withIds(campaignID))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withDynamicTextCampaignFieldNames(DynamicTextCampaignFieldEnum.SETTINGS));
        assumeThat("вернулась 1 кампания", getResponse.getCampaigns(), hasSize(1));
        assumeThat("вернулись текстовые параметры кампании", getResponse.getCampaigns().get(0).getDynamicTextCampaign(),
                notNullValue());
        List<DynamicTextCampaignSettingGet> settings =
                getResponse.getCampaigns().get(0).getDynamicTextCampaign().getSettings();
        assumeThat("вернулись Settings кампании", settings, notNullValue());

        List<YesNoEnum> value = settings.stream()
                .filter(setting -> setting.getOption().equals(DynamicTextCampaignSettingsGetEnum.REQUIRE_SERVICING))
                .map(DynamicTextCampaignSettingGet::getValue)
                .collect(Collectors.toList());
        assertThat("вернулся ожидаемый параметр", value, equalTo(List.of(expectedValue)));
    }
}
