package ru.yandex.autotests.direct.api.campaigns.add.dynamictextcampaign.strategy;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCpcAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyMaximumClicksAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.currency.Currency;
import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

/**
 * Created by pavryabov on 19.11.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Создание кампании при несоответствии имени стратегии и набора переданных параметров стратегии")
public class StrategyNameMismatchParamsTest {
    private static final Currency currency = CurrencyCode.RUB.getCurrency();

    @ClassRule
    public static ApiSteps api = new ApiSteps().asUnknownClient();

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public DynamicTextCampaignSearchStrategyAddMap searchStrategy;

    @Parameterized.Parameter(value = 2)
    public DynamicTextCampaignNetworkStrategyAddMap networkStrategy;

    @Parameterized.Parameter(value = 3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "strategy = {0}")
    public static Collection strategies() {
        Long minWeeklySpendLimit = convertToMicros(currency.getMinAutobudget());
        Long minAveragePrice = convertToMicros(currency.getMinAutobudgetAvgPrice());
        Object[][] data = new Object[][]{
                {"Search: несоответствие имени и параметров",
                        new DynamicTextCampaignSearchStrategyAddMap()
                                .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                                .withAverageCpc(
                                new StrategyAverageCpcAddMap()
                                        .withAverageCpc(minAveragePrice)
                                        .withWeeklySpendLimit(minWeeklySpendLimit)),
                        new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff(),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.SEARCH_STRATEGY_NAME_MISMATCH_WITH_PARAMETERS))},
                {"Search: стратегия не требующая параметров",
                        new DynamicTextCampaignSearchStrategyAddMap()
                                .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION)
                                .withAverageCpc(
                                new StrategyAverageCpcAddMap()
                                        .withAverageCpc(minAveragePrice)
                                        .withWeeklySpendLimit(minWeeklySpendLimit)),
                        new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff(),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.SEARCH_STRATEGY_NAME_MISMATCH_WITH_PARAMETERS))},
                //DIRECT-46816
                {"Search: стратегия без необходимых парметров",
                        new DynamicTextCampaignSearchStrategyAddMap()
                                .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_CPC),
                        new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff(),
                        ExpectedResult.errorsIgnoringDetails(
                                new Notification(4000, Api5ErrorDetails.STRATEGY_ON_SEARCH_MUST_CONTAINS_SETTINGS,
                                        DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_CPC))},
                {"Search: лишние параметры стратегий",
                        new DynamicTextCampaignSearchStrategyAddMap()
                                .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                                .withAverageCpc(new StrategyAverageCpcAddMap()
                                        .withAverageCpc(minAveragePrice)
                                        .withWeeklySpendLimit(minWeeklySpendLimit))
                                .withWbMaximumClicks(new StrategyMaximumClicksAddMap()
                                .defaultStrategyMaximumClicks(CurrencyCode.RUB.getCurrency())),
                        new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff(),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.MULTIPLE_SEARCH_STRATEGY_PARAMS))}
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("132")
    public void nameMismatchParamsTest() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                                .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                        .withSearch(searchStrategy)
                                        .withNetwork(networkStrategy)))),
                expectedResult);
    }
}
