package ru.yandex.autotests.direct.api.campaigns.add.dynamictextcampaign.strategy.averagecpa;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCpaAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.currency.Currency;
import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Cценарии проверки параметра GoalId при создании кампании со стратегией AverageCpa")
//Тест проверяет валидацию целей с включенной фичей disable_all_goals_optimization_for_dna
public class StrategyAverageCpaGoalIdTest {
    private static final Currency currency = CurrencyCode.RUB.getCurrency();
    private static final Long overMinAverageCpa = convertToMicros(
            currency.getMinAutobudgetAvgPrice().add(currency.getAuctionStep()));
    private static final Integer counterId = MetrikaGoals.VALID_COUNTER_ID;
    @ClassRule
    public static ApiSteps api = new ApiSteps();
    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public Long goalId;

    @Parameterized.Parameter(value = 2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection<?> strategies() {
        Long[] goalIds = MetrikaGoals.getConterGoalIds(counterId, 1);
        Object[][] data = new Object[][]{
                {"По всем целям", 0L, ExpectedResult.errors(new Notification(4000,
                        Api5ErrorDetails.ALL_GOALS_OPTIMIZATION_IS_PROHIBITED))},
                {"По конкретной цели", goalIds[0], ExpectedResult.success()},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareData() {
        var client = api.createClient();
        api.as(client);
        api.userSteps.featureSteps().ensureClientHasFeature(client, FeatureName.DISABLE_ALL_GOALS_OPTIMIZATION_FOR_DNA);
    }

    @Test
    public void averageCpaCreateTest() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                                .withCounterIds(counterId)
                                .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                        .withSearch(new DynamicTextCampaignSearchStrategyAddMap()
                                                .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_CPA)
                                                .withAverageCpa(new StrategyAverageCpaAddMap()
                                                        .withAverageCpa(overMinAverageCpa)
                                                        .withGoalId(goalId)
                                                        .withBidCeiling(null)
                                                        .withWeeklySpendLimit(null)))
                                        .withNetwork(new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff())))),
                expectedResult);
    }
}
