package ru.yandex.autotests.direct.api.campaigns.add.dynamictextcampaign.strategy.averagecpc;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCpcAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.currency.Currency;
import ru.yandex.direct.currency.CurrencyAmount;
import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.currency.Money;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;

/**
 * Created by pavryabov on 19.11.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Негативные сценарии проверки параметра AveragePrice при добавлении мобильной кампании со стратегией " +
        "AverageCpc")
public class StrategyAverageCpcAveragePriceNegativeTest {
    private static final Currency currency = CurrencyCode.RUB.getCurrency();

    private static final Money minPrice = Money.valueOf(currency.getMinPrice(), currency.getCode());
    private static final Money maxPrice = Money.valueOf(currency.getMaxPrice(), currency.getCode());
    private static final Money auctionStep = Money.valueOf(currency.getAuctionStep(), currency.getCode());
    private static final Money weeklyLimit = Money.valueOf(
            currency.getMinAutobudget(),
            currency.getCode());

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @Parameterized.Parameter()
    public String description;

    @Parameterized.Parameter(value = 1)
    public StrategyAverageCpcAddMap params;

    @Parameterized.Parameter(value = 2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection<?> strategies() {

        Object[][] data = new Object[][]{
                {"Нулевое значение", new StrategyAverageCpcAddMap().withAverageCpc(0L),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.AVERAGE_PRICE_SHOULD_BE_MORE_THAN,
                                CurrencyAmount.fromMoney(minPrice)))},
                {"Отрицательное значение", new StrategyAverageCpcAddMap().withAverageCpc(-1L),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.AVERAGE_PRICE_SHOULD_BE_MORE_THAN,
                                CurrencyAmount.fromMoney(minPrice)))},
                {"Значение меньше минимального",
                        new StrategyAverageCpcAddMap()
                                .withAverageCpc(minPrice.subtract(auctionStep).micros()),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.AVERAGE_PRICE_SHOULD_BE_MORE_THAN,
                                CurrencyAmount.fromMoney(minPrice)))},
                {"Значение больше максимального",
                        new StrategyAverageCpcAddMap()
                                .withAverageCpc(minPrice.add(auctionStep).micros()),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.AVERAGE_PRICE_SHOULD_BE_LESS_THAN,
                                CurrencyAmount.fromMoney(maxPrice)))},
                {"Среднее значение ставки больше недельного бюджета",
                        new StrategyAverageCpcAddMap()
                                .withAverageCpc(weeklyLimit.add(auctionStep).micros())
                                .withWeeklySpendLimit(weeklyLimit.micros()),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.WEEKLY_BUDGET_SHOULD_BE_GREATER_THAN_AVERAGE_PRICE))},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareData() {
        api.asUnknownClient();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("133")
    public void averagePriceNegativeTest() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                                .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                        .withSearch(new DynamicTextCampaignSearchStrategyAddMap()
                                                .withBiddingStrategyType(
                                                        DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_CPC)
                                                .withAverageCpc(params))
                                        .withNetwork(
                                                new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff())))),
                expectedResult);
    }
}
