package ru.yandex.autotests.direct.api.campaigns.add.dynamictextcampaign.strategy.averagecpc;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCpcAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.currency.Currency;
import ru.yandex.direct.currency.CurrencyAmount;
import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.currency.Money;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;

/**
 * Created by pavryabov on 19.11.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Негативные сценарии проверки параметра WeeklySpendLimit при добавлении мобильных кампании со стратегией" +
        " AverageCpc")
public class StrategyAverageCpcWeeklySpendLimitNegativeTest {
    private static final Currency currency = CurrencyCode.RUB.getCurrency();
    private static final Money minLimit = Money.valueOf(
            currency.getMinAutobudget(),
            currency.getCode());
    private static final Money maxLimit = Money.valueOf(
            currency.getMaxAutobudget(),
            currency.getCode());
    private static final Money averagePrice = Money.valueOf(currency.getMinAutobudgetAvgPrice(), currency.getCode());
    private static final Money auctionStep = Money.valueOf(currency.getAuctionStep(), currency.getCode());

    @ClassRule
    public static ApiSteps api = new ApiSteps().asUnknownClient();

    @Parameterized.Parameter()
    public String description;

    @Parameterized.Parameter(value = 1)
    public Long weeklyLimit;

    @Parameterized.Parameter(value = 2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection<?> strategies() {
        Object[][] data = new Object[][]{
                {"Нулевое значение", 0L,
                        ExpectedResult.errorsIgnoringDetails(
                                new Notification(4000,
                                        Api5ErrorDetails.WEEKLY_LIMIT_SHOULD_BE_MORE_THAN,
                                        CurrencyAmount.fromMoney(minLimit)),
                                new Notification(4000,
                                        Api5ErrorDetails.WEEKLY_LIMIT_SHOULD_BE_MORE_THAN,
                                        CurrencyAmount.fromMoney(minLimit))
                        )},
                {"Отрицательное значение", -1L,
                        ExpectedResult.errorsIgnoringDetails(
                                new Notification(4000,
                                        Api5ErrorDetails.WEEKLY_LIMIT_SHOULD_BE_MORE_THAN,
                                        CurrencyAmount.fromMoney(minLimit)),
                                new Notification(4000,
                                        Api5ErrorDetails.WEEKLY_LIMIT_SHOULD_BE_MORE_THAN,
                                        CurrencyAmount.fromMoney(minLimit))
                        )},
                {"Значение меньше минимального", minLimit.subtract(auctionStep).micros(),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.WEEKLY_LIMIT_SHOULD_BE_MORE_THAN,
                                CurrencyAmount.fromMoney(minLimit)))},
                {"Значение больше максимального", maxLimit.add(auctionStep).micros(),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.WEEKLY_LIMIT_IS_TOO_HIGH,
                                CurrencyAmount.fromMoney(maxLimit)))}
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("135")
    public void weeklyLimitNegativeTest() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                                .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                        .withSearch(new DynamicTextCampaignSearchStrategyAddMap()
                                                .withBiddingStrategyType(
                                                        DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_CPC)
                                                .withAverageCpc(new StrategyAverageCpcAddMap()
                                                        .withWeeklySpendLimit(weeklyLimit)
                                                        .withAverageCpc(averagePrice.micros())))
                                        .withNetwork(
                                                new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff())))),
                expectedResult);
    }
}
