package ru.yandex.autotests.direct.api.campaigns.add.dynamictextcampaign.strategy.averagecrr;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCrrAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.currency.Currency;
import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.currency.Money;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Негативные сценарии создания кампании со стратегией AverageCrr")
public class StrategyAverageCrrNegativeTest {
    private static final Currency currency = CurrencyCode.RUB.getCurrency();
    private static final Money minLimit = Money.valueOf(
            currency.getMinAutobudget(),
            currency.getCode());
    private static final Money maxLimit = Money.valueOf(
            currency.getMaxAutobudget(),
            currency.getCode());
    private static final Money auctionStep = Money.valueOf(currency.getAuctionStep(), currency.getCode());

    @ClassRule
    public static final ApiSteps api = new ApiSteps();

    @Parameterized.Parameter(value = 0)
    public String description;
    @Parameterized.Parameter(value = 1)
    public StrategyAverageCrrAddMap strategyData;
    @Parameterized.Parameter(value = 2)
    public ExpectedResult expectedResult;
    private DynamicTextCampaignStrategyAddMap strategyMap;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {
                        "ДРР меньше 1%",
                        new StrategyAverageCrrAddMap()
                                .withCrr(StrategyAverageCrrAddMap.MIN_CRR - 1)
                                .withWeeklySpendLimit(StrategyAverageCrrAddMap.DEFAULT_WEEKLY_SPEND_LIMIT)
                                .withGoalId(MetrikaGoals.getGoalForCounter(MetrikaGoals.VALID_COUNTER_ID)),
                        ExpectedResult.errorWithCode(4000),
                },
                {
                        "ДРР больше 500%",
                        new StrategyAverageCrrAddMap()
                                .withCrr(StrategyAverageCrrAddMap.MAX_CRR + 1)
                                .withWeeklySpendLimit(StrategyAverageCrrAddMap.DEFAULT_WEEKLY_SPEND_LIMIT)
                                .withGoalId(MetrikaGoals.getGoalForCounter(MetrikaGoals.VALID_COUNTER_ID)),
                        ExpectedResult.errorWithCode(4000),
                },
                {
                        "Бюджет меньше минимального значения",
                        new StrategyAverageCrrAddMap()
                                .withCrr(StrategyAverageCrrAddMap.DEFAULT_CRR)
                                .withWeeklySpendLimit(minLimit.subtract(auctionStep).micros())
                                .withGoalId(MetrikaGoals.getGoalForCounter(MetrikaGoals.VALID_COUNTER_ID)),
                        ExpectedResult.errorWithCode(4000),
                },
                {
                        "Бюджет больше максимального значения",
                        new StrategyAverageCrrAddMap()
                                .withCrr(StrategyAverageCrrAddMap.DEFAULT_CRR)
                                .withWeeklySpendLimit(maxLimit.add(auctionStep).micros())
                                .withGoalId(MetrikaGoals.getGoalForCounter(MetrikaGoals.VALID_COUNTER_ID)),
                        ExpectedResult.errorWithCode(4000),
                },
                {
                        "Цель не задана",
                        new StrategyAverageCrrAddMap()
                                .withCrr(StrategyAverageCrrAddMap.DEFAULT_CRR)
                                .withWeeklySpendLimit(StrategyAverageCrrAddMap.DEFAULT_WEEKLY_SPEND_LIMIT)
                                .withGoalId(0L),
                        ExpectedResult.errorWithCode(4000),
                }
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareData() {
        var client = api.createClient();
        api.as(client);

        api.userSteps.featureSteps().ensureClientHasFeature(client, FeatureName.CRR_STRATEGY_ALLOWED);
        api.userSteps.featureSteps().ensureClientHasFeature(client, FeatureName.FIX_CRR_STRATEGY_ALLOWED);
        api.userSteps.featureSteps().ensureClientHasFeature(client, FeatureName.DISABLE_ALL_GOALS_OPTIMIZATION_FOR_DNA);
    }

    @Before
    public void clearUnits() {
        strategyMap = new DynamicTextCampaignStrategyAddMap()
                .withSearch(new DynamicTextCampaignSearchStrategyAddMap()
                        .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_CRR)
                        .withAverageCrr(strategyData)
                ).withNetwork(new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff());
    }

    @Test
    public void shouldReturnError() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                                .withCounterIds(MetrikaGoals.VALID_COUNTER_ID)
                                .withBiddingStrategy(strategyMap)
                        )
                ),
                expectedResult
        );
    }
}
