package ru.yandex.autotests.direct.api.campaigns.add.dynamictextcampaign.strategy.averagecrr;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.CampaignsSelectionCriteria;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCrrAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCrrMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.currency.Currency;
import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.currency.Money;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Сценарии проверки создания кампании со стратегией AverageCrr")
public class StrategyAverageCrrPositiveTest {
    private static final Currency currency = CurrencyCode.RUB.getCurrency();
    private static final Money minLimit = Money.valueOf(
            currency.getMinAutobudget(),
            currency.getCode());
    private static final Money maxLimit = Money.valueOf(
            currency.getMaxAutobudget(),
            currency.getCode());

    @ClassRule
    public static final ApiSteps api = new ApiSteps();

    @Parameterized.Parameter(value = 0)
    public String description;
    @Parameterized.Parameter(value = 1)
    public Long goalId;
    @Parameterized.Parameter(value = 2)
    public Integer crr;
    @Parameterized.Parameter(value = 3)
    public Long weeklySpendLimit;
    private DynamicTextCampaignStrategyAddMap strategyMap;
    private DynamicTextCampaignStrategyMap expectedStrategyMap;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection<?> strategies() {
        Object[][] data = new Object[][]{
                {
                        "Создание новой кампании",
                        MetrikaGoals.VALID_GOAL_ID,
                        StrategyAverageCrrAddMap.DEFAULT_CRR,
                        StrategyAverageCrrAddMap.DEFAULT_WEEKLY_SPEND_LIMIT,
                },
                {
                        "Создание новой кампании с минимальным ДРР",
                        MetrikaGoals.VALID_GOAL_ID,
                        StrategyAverageCrrAddMap.MIN_CRR,
                        StrategyAverageCrrAddMap.DEFAULT_WEEKLY_SPEND_LIMIT,
                },
                {
                        "Создание новой кампании с максимальным ДРР",
                        MetrikaGoals.VALID_GOAL_ID,
                        StrategyAverageCrrAddMap.MAX_CRR,
                        StrategyAverageCrrAddMap.DEFAULT_WEEKLY_SPEND_LIMIT,
                },
                {
                        "Создание новой кампании с минимальным бюджетом",
                        MetrikaGoals.VALID_GOAL_ID,
                        StrategyAverageCrrAddMap.DEFAULT_CRR,
                        minLimit.micros(),
                },
                {
                        "Создание новой кампании с максимальным бюджетм",
                        MetrikaGoals.VALID_GOAL_ID,
                        StrategyAverageCrrAddMap.DEFAULT_CRR,
                        maxLimit.micros(),
                },
                {
                        "Создание новой кампании без недельного бюджета",
                        MetrikaGoals.VALID_GOAL_ID,
                        StrategyAverageCrrAddMap.DEFAULT_CRR,
                        null
                }
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareData() {
        var client = api.createClient();
        api.as(client);

        api.userSteps.featureSteps().ensureClientHasFeature(client, FeatureName.CRR_STRATEGY_ALLOWED);
        api.userSteps.featureSteps().ensureClientHasFeature(client, FeatureName.FIX_CRR_STRATEGY_ALLOWED);
    }

    @Before
    public void clearUnits() {
        strategyMap = new DynamicTextCampaignStrategyAddMap()
                .withSearch(new DynamicTextCampaignSearchStrategyAddMap()
                        .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_CRR)
                        .withAverageCrr(new StrategyAverageCrrAddMap()
                                .withCrr(crr)
                                .withWeeklySpendLimit(weeklySpendLimit)
                                .withGoalId(goalId)
                        )
                ).withNetwork(new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff());

        expectedStrategyMap = new DynamicTextCampaignStrategyMap()
                .withSearch(new DynamicTextCampaignSearchStrategyMap()
                        .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_CRR)
                        .withAverageCrr(new StrategyAverageCrrMap()
                                .withGoalId(goalId)
                                .withCrr(crr)
                                .withWeeklySpendLimit(weeklySpendLimit)
                        )
                ).withNetwork(new DynamicTextCampaignNetworkStrategyMap().defaultServingOff());
    }

    @Test
    public void shouldCreateCampaign() {
        AddResponse response = api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                                .withCounterIds(MetrikaGoals.VALID_COUNTER_ID)
                                .withBiddingStrategy(strategyMap)
                        )
                ),
                ExpectedResult.success()
        );

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteria()
                                .withIds(response.getAddResults().get(0).getId())
                        )
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withDynamicTextCampaignFieldNames(DynamicTextCampaignFieldEnum.BIDDING_STRATEGY)
        );

        assumeThat("получили кампанию", campaigns, hasSize(1));

        assertThat("получили корректные стратегии",
                campaigns.get(0).getDynamicTextCampaign().getBiddingStrategy(),
                beanDifferV5(expectedStrategyMap.getBean())
        );
    }
}
