package ru.yandex.autotests.direct.api.campaigns.add.dynamictextcampaign.strategy.averageroi;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.CampaignsSelectionCriteria;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsArrayMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageRoiAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageRoiMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pashkus on 28.09.2019.
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Cценарии проверки параметра GoalId при создании кампании со стратегией AverageRoi")
public class StrategyAverageRoiTest {
    @ClassRule
    public static final ApiSteps api = new ApiSteps().asUnknownClient();
    @Parameterized.Parameter(value = 0)
    public String description;
    @Parameterized.Parameter(value = 1)
    public Long goalId;
    @Parameterized.Parameter(value = 2)
    public ExpectedResult expectedResult;
    private DynamicTextCampaignStrategyAddMap strategyMap;
    private DynamicTextCampaignStrategyMap expectedStrategyMap;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection<?> strategies() {
        Object[][] data = new Object[][]{
                {"Оптимизация по ключевым целям", 13L,
                        ExpectedResult.success()},
        };
        return Arrays.asList(data);
    }

    @Before
    public void clearUnits() {
        strategyMap = new DynamicTextCampaignStrategyAddMap()
                .withSearch(new DynamicTextCampaignSearchStrategyAddMap()
                        .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_ROI)
                        .withAverageRoi(new StrategyAverageRoiAddMap()
                                .defaultStrategyAverageRoi()
                                .withGoalId(goalId)))
                .withNetwork(new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff());


        expectedStrategyMap = new DynamicTextCampaignStrategyMap()
                .withSearch(new DynamicTextCampaignSearchStrategyMap()
                        .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_ROI)
                        .withAverageRoi(new StrategyAverageRoiMap()
                                .withReserveReturn(StrategyAverageRoiAddMap.DEFAULT_RESERVE_RETURN)
                                .withRoiCoef(StrategyAverageRoiAddMap.DEFAULT_ROI_COEF)
                                .withGoalId(goalId)
                                .withBidCeiling(null)
                                .withProfitability(null)
                                .withWeeklySpendLimit(null)))
                .withNetwork(new DynamicTextCampaignNetworkStrategyMap().defaultServingOff());
    }

    @Test
    public void goalIdTest() {
        AddResponse response = api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                                .withCounterIds(MetrikaGoals.VALID_COUNTER_ID)
                                .withPriorityGoals(new PriorityGoalsArrayMap()
                                        .withItems(new PriorityGoalsItemMap()
                                                .withGoalId(MetrikaGoals.VALID_GOAL_ID)
                                                .withValue(13_000_000L)))
                                .withBiddingStrategy(strategyMap))),
                ExpectedResult.success());

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteria()
                                .withIds(response.getAddResults().get(0).getId()))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withDynamicTextCampaignFieldNames(DynamicTextCampaignFieldEnum.BIDDING_STRATEGY));

        assumeThat("получили кампанию", campaigns, hasSize(1));

        assertThat("получили корректные стратегии", campaigns.get(0).getDynamicTextCampaign().getBiddingStrategy(),
                beanDifferV5(expectedStrategyMap
                        .withNetwork(new DynamicTextCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(DynamicTextCampaignNetworkStrategyTypeEnum.SERVING_OFF))
                        .getBean()));
    }
}
