package ru.yandex.autotests.direct.api.campaigns.add.dynamictextcampaign.strategy.maximumclicks;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyMaximumClicksAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.currency.Currency;
import ru.yandex.direct.currency.CurrencyAmount;
import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.currency.Money;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;

/**
 * Created by pavryabov on 19.11.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Негативные сценарии проверки параметра BidCeiling при добавлении мобильной кампании со стратегией " +
        "MaximumClicks")
public class StrategyMaximumClicksBidCeilingNegativeTest {
    private static final Currency currency = CurrencyCode.RUB.getCurrency();
    private static final Money minValue = Money.valueOf(currency.getMinPrice(), currency.getCode());
    private static final Money maxValue = Money.valueOf(currency.getMaxPrice(), currency.getCode());
    private static final Money weeklyLimit = maxValue.multiply(BigDecimal.valueOf(2));
    private static final Money auctionStep = Money.valueOf(currency.getAuctionStep(), currency.getCode());

    @ClassRule
    public static ApiSteps api = new ApiSteps().asUnknownClient();

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public Long bidCeiling;

    @Parameterized.Parameter(value = 2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {"Нулевое значение", 0L,
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.MAX_BID_SHOULD_BE_MORE_THAN,
                                CurrencyAmount.fromMoney(minValue)))},
                {"Отрицательное значение", -1L,
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.MAX_BID_SHOULD_BE_MORE_THAN,
                                CurrencyAmount.fromMoney(minValue)))},
                {"Значение меньше минимального", minValue.subtract(auctionStep).micros(),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.MAX_BID_SHOULD_BE_MORE_THAN,
                                CurrencyAmount.fromMoney(minValue)))},
                {"Значение больше максимального", maxValue.add(auctionStep).micros(),
                        ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                                Api5ErrorDetails.MAX_BID_SHOULD_BE_LESS_THAN,
                                CurrencyAmount.fromMoney(maxValue)))},
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("137")
    public void bidCeilingNegativeTest() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                                .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                        .withSearch(new DynamicTextCampaignSearchStrategyAddMap()
                                                .withBiddingStrategyType(
                                                        DynamicTextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                                                .withWbMaximumClicks(new StrategyMaximumClicksAddMap()
                                                        .withWeeklySpendLimit(weeklyLimit.micros())
                                                        .withBidCeiling(bidCeiling)))
                                        .withNetwork(
                                                new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff())))),
                expectedResult);
    }
}
