package ru.yandex.autotests.direct.api.campaigns.add.dynamictextcampaign.strategy.maximumconversionrate;

import java.math.BigDecimal;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyMaximumConversionRateAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.entity.campaign.model.StrategyData;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.direct.currency.Currency;
import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.currency.Money;
import ru.yandex.direct.utils.JsonUtils;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.model.api5.campaigns.StrategyMaximumConversionRateAddMap.MEANINGFUL_GOAL_OPTIMIZATION_GOAL_ID;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка обновлении стратегии на MaximumConversionRate с установкой оптимизации по ключевым целям")
public class StrategyMaximumConversionRateMeaningfulGoalIdDbTest {
    private static final Currency currency = CurrencyCode.RUB.getCurrency();
    private static final Money weeklyLimit = Money.valueOf(
            currency.getMaxPrice().multiply(BigDecimal.valueOf(2)),
            currency.getCode());

    @ClassRule
    public static ApiSteps api = new ApiSteps();
    private static ClientInfo client;
    private static Long campaignId;

    @BeforeClass
    public static void prepareData() {
        client = api.createClient();
        api.as(client);
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
    }

    @Test
    public void settingRoiPriorityGoalsOptimizationAndPriorityGoalsTest() {
        AddResponse response = api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                                .withCounterIds(MetrikaGoals.VALID_COUNTER_ID)
                                .withPriorityGoals(new PriorityGoalsItemMap()
                                        .withGoalId(MetrikaGoals.VALID_GOAL_ID)
                                        .withValue(13_000_000L))
                                .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                        .withSearch(new DynamicTextCampaignSearchStrategyAddMap()
                                                .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CONVERSION_RATE)
                                                .withWbMaximumConversionRate(new StrategyMaximumConversionRateAddMap()
                                                        .withWeeklySpendLimit(weeklyLimit.micros())
                                                        .withGoalId(MEANINGFUL_GOAL_OPTIMIZATION_GOAL_ID)))
                                        .withNetwork(new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff())))),
                ExpectedResult.success());

        assumeThat("получили результаты добавления кампании", response.getAddResults(), hasSize(1));
        campaignId = response.getAddResults().get(0).getId();

        assertThat("campaigns.strategy_data.goal_id соответствует ожиданиям",
                getActualGoalId(),
                equalTo(MEANINGFUL_GOAL_OPTIMIZATION_GOAL_ID));
    }

    private Long getActualGoalId() {
        String strategyDataJson = api.userSteps.getDirectJooqDbSteps().useShardForClient(client).getContext()
                .select(CAMPAIGNS.STRATEGY_DATA)
                .from(CAMPAIGNS)
                .where(CAMPAIGNS.CID.eq(campaignId))
                .fetchSingle()
                .value1();
        StrategyData data = JsonUtils.fromJson(strategyDataJson, StrategyData.class);
        return data.getGoalId();
    }

}
