package ru.yandex.autotests.direct.api.campaigns.add.dynamictextcampaign.strategy.payforconversion;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyPayForConversionAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.direct.currency.Currency;
import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.currency.Money;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
/*
 *Тест работает с включенными фичей cpa_pay_for_conversions_extended_mode
 */

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@RunWith(Parameterized.class)
@Description("Негативные сценарии проверки параметра GoalId при создании кампании со стратегией PayForConversion")
public class StrategyPayForConversionGoalIdNegativeTest {
    private static final Currency currency = CurrencyCode.RUB.getCurrency();
    private static final Money minAverageCpa = Money.valueOf(currency.getMinAutobudgetAvgCpa(), currency.getCode());
    private static final Money auctionStep = Money.valueOf(currency.getAuctionStep(), currency.getCode());

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @Parameterized.Parameter(value = 0)
    public String description;
    @Parameterized.Parameter(value = 1)
    public Long goalId;
    @Parameterized.Parameter(value = 2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection<?> strategies() {
        Long[] goalIds = MetrikaGoals.getConterGoalIds(MetrikaGoals.VALID_COUNTER_ID, 1);
        Object[][] data = new Object[][]{
                {"По всем целям", 0L, ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                        Api5ErrorDetails.PAY_FOR_CONVERSIOIN_DOES_NOT_ALLOW_ALL_GOALS_OPTIMIZATION))},
                {"Цель к которой нет доступа", 62047749L, ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                        Api5ErrorDetails.SPECIFIED_GOAL_NOT_FOUND))},
                {"Ключевые цели", 13L, ExpectedResult.errorsIgnoringDetails(new Notification(4000,
                        Api5ErrorDetails.SPECIFIED_GOAL_NOT_FOUND))},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareData() {
        ClientInfo client = api.createClient();
        api.as(client);
    }

    @Test
    public void payForConversionWithoutCounterGoalIdNegativeTest() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                                .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                        .withSearch(new DynamicTextCampaignSearchStrategyAddMap()
                                                .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.PAY_FOR_CONVERSION)
                                                .withPayForConversion(new StrategyPayForConversionAddMap()
                                                        .withCpa(minAverageCpa.add(auctionStep).micros())
                                                        .withGoalId(goalId)
                                                        .withWeeklySpendLimit(null)))
                                        .withNetwork(new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff())))),
                expectedResult);

    }

    @Test
    public void payForConversionGoalIdNegativeTest() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                                .withCounterIds(MetrikaGoals.VALID_COUNTER_ID)
                                .withBiddingStrategy(new DynamicTextCampaignStrategyAddMap()
                                        .withSearch(new DynamicTextCampaignSearchStrategyAddMap()
                                                .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.PAY_FOR_CONVERSION)
                                                .withPayForConversion(new StrategyPayForConversionAddMap()
                                                        .withCpa(minAverageCpa.add(auctionStep).micros())
                                                        .withGoalId(goalId)
                                                        .withWeeklySpendLimit(null)))
                                        .withNetwork(new DynamicTextCampaignNetworkStrategyAddMap().defaultServingOff())))),
                expectedResult);
    }
}
