package ru.yandex.autotests.direct.api.creatives;

import com.yandex.direct.api.v5.creatives.BusinessTypeEnum;
import com.yandex.direct.api.v5.creatives.CreativeGetItem;
import com.yandex.direct.api.v5.creatives.GetRequest;
import com.yandex.direct.api.v5.creatives.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.autotests.directapi.apiclient.errors.Api5JsonError;
import ru.yandex.autotests.directapi.steps.ApiSteps;
import ru.yandex.autotests.directapi.steps.CreativeSteps;
import ru.yandex.direct.core.entity.banner.model.old.OldPerformanceBanner;
import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.core.entity.creative.model.CreativeBusinessType;
import ru.yandex.direct.core.testing.info.BannerCreativeInfo;
import ru.yandex.direct.core.testing.info.ClientInfo;
import ru.yandex.direct.core.testing.info.PerformanceAdGroupInfo;
import ru.yandex.qatools.allure.annotations.Features;

import static com.google.common.base.Preconditions.checkState;
import static org.assertj.core.api.Assertions.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;
import static ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies.onlyExpectedFields;
import static ru.yandex.direct.test.utils.assertj.Conditions.matchedBy;

@Features(CreativesFeatures.GET)
public class GetCreativesTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    private static Creative creative;
    private static CreativeSteps creativeSteps;

    @BeforeClass
    public static void init() {
        ClientInfo clientInfo = api.createClient();
        api.as(clientInfo);
        PerformanceAdGroupInfo adGroupInfo = api.userSteps().adGroupsSteps().addDefaultPerformanceAdGroup(clientInfo);
        BannerCreativeInfo<OldPerformanceBanner> bannerCreativeInfo =
                api.userSteps().bannerCreativeSteps().createPerformanceBannerCreative(adGroupInfo);
        creative = bannerCreativeInfo.getCreative();
        creativeSteps = api.userSteps().creativeSteps();
    }

    @Test
    public void getCreative_success() {
        checkState(creative.getBusinessType() == CreativeBusinessType.RETAIL, "unexpected BusinessType");
        CreativeGetItem expectedItem = TestCreatives.getCreativeGetItem(creative.getId(), creative.getName(),
                creative.getCreativeGroupId(), creative.getGroupName(), BusinessTypeEnum.RETAIL);

        GetRequest getRequest = TestCreatives.createGetRequest(creative.getId());
        GetResponse getResponse = creativeSteps.sendGetRequest(getRequest);
        CreativeGetItem actualItem = getResponse.getCreatives().get(0);

        assertThat(actualItem).is(matchedBy(beanDiffer(expectedItem).useCompareStrategy(onlyExpectedFields())));
    }

    @Test
    public void getCreative_whenCreativeNotExist_emptyResult() {
        long notExistPerfFilterId = Integer.MAX_VALUE - 1L;
        GetRequest getRequest = TestCreatives.createGetRequest(notExistPerfFilterId);
        GetResponse getResponse = creativeSteps.sendGetRequest(getRequest);
        assertThat(getResponse.getCreatives()).isEmpty();
    }

    @Test
    public void getCreative_whenOwnerSomebodyElse_emptyResult() {
        PerformanceAdGroupInfo anotherAdGroupInfo = api.userSteps().adGroupsSteps().addDefaultPerformanceAdGroup();
        BannerCreativeInfo<OldPerformanceBanner> anotherBannerCreativeInfo =
                api.userSteps().bannerCreativeSteps().createPerformanceBannerCreative(anotherAdGroupInfo);
        GetRequest getRequest = TestCreatives.createGetRequest(anotherBannerCreativeInfo.getCreativeId());
        GetResponse getResponse = creativeSteps.sendGetRequest(getRequest);
        assertThat(getResponse.getCreatives()).isEmpty();
    }

    @Test(expected = Api5JsonError.class)
    public void resumeSmartAdTarget_withEmptyRequest_failure() {
        GetRequest getRequest = new GetRequest();
        creativeSteps.sendGetRequest(getRequest);
    }

}
